﻿#pragma once
#include <PI.h>

/* Multiplicación de matrices 3x3. Originalmente para matrices de rotación, de ahí el nombre del fichero,
los nombres de las funciones y que se confundan traspuestas con inversas, ya que para matrices de rotación
son lo mismo. Estas fuciones nunca calculan la inversa de una matriz genérica, sino que allá donde dicen
inversa ha de entenderse traspuesta.*/

//A=B*C
sinline void mmulrot_base_dbl(double *B, double *C, double *A){
	zeroset_double(A,9);
	for(cint it=3;it;){ it--;
		cint jt=3;
		do{ jt--;
			double aux=*B++;
			*A+++=aux**C++;
			*A+++=aux**C++;
			*A+=aux**C++;	A-=2;
		}while(jt);
		A+=3, C-=9;
	}
}
sinline void mmulrot_dbl(double B[][3], double C[][3], double A[][3]){
	mmulrot_base_dbl(B[0],C[0],A[0]);
}
sinline void mmulrot_base_fl(float *B, float *C, float *A){
	zeroset_float(A,9);
	for(cint it=3;it;){ it--;
		cint jt=3;
		do{ jt--;
			float aux=*B++;
			*A+++=aux**C++;
			*A+++=aux**C++;
			*A+=aux**C++;	A-=2;
		}while(jt);
		A+=3, C-=9;
	}
}
sinline void mmulrot_fl(float B[][3], float C[][3], float A[][3]){
	mmulrot_base_fl(B[0],C[0],A[0]);
}

//A=B*C_traspuesta
sinline void mmulrot_inv_base_dbl(double *B, double *C_inv, double *A){
	for(cint it=3;it;){ it--;
		cint jt=3;
		do{ jt--;
			double aux;
			aux=*B++**C_inv++;
			aux+=*B++**C_inv++;
			aux+=*B**C_inv++;	B-=2;
			*A++=aux;
		}while(jt);
		B+=3, C_inv-=9;
	}
}
sinline void mmulrot_inv_dbl(double B[][3], double C_inv[][3], double A[][3]){
	mmulrot_inv_base_dbl(B[0],C_inv[0],A[0]);
}
sinline void mmulrot_inv_base_fl(float *B, float *C_inv, float *A){
	for(cint it=3;it;){ it--;
		cint jt=3;
		do{ jt--;
			float aux;
			aux=*B++**C_inv++;
			aux+=*B++**C_inv++;
			aux+=*B**C_inv++;	B-=2;
			*A++=aux;
		}while(jt);
		B+=3, C_inv-=9;
	}
}
sinline void mmulrot_inv_fl(float B[][3], float C_inv[][3], float A[][3]){
	mmulrot_inv_base_fl(B[0],C_inv[0],A[0]);
}


//Transpone una matriz
sinline void MinversaRot_dbl(double M[][3]){
	double aux;
	aux=M[0][1]; M[0][1]=M[1][0]; M[1][0]=aux;
	aux=M[0][2]; M[0][2]=M[2][0]; M[2][0]=aux;
	aux=M[1][2]; M[1][2]=M[2][1]; M[2][1]=aux;
}
sinline void MinversaRot_fl(float M[][3]){
	float aux;
	aux=M[0][1]; M[0][1]=M[1][0]; M[1][0]=aux;
	aux=M[0][2]; M[0][2]=M[2][0]; M[2][0]=aux;
	aux=M[1][2]; M[1][2]=M[2][1]; M[2][1]=aux;
}
//Transpone M guardando el resultado en Mt
sinline void Mtransponer_dbl(const double M[][3], double Mt[][3]){
	Mt[0][0]=M[0][0];	Mt[1][1]=M[1][1];	Mt[2][2]=M[2][2];
	Mt[0][1]=M[1][0]; Mt[1][0]=M[0][1];
	Mt[0][2]=M[2][0]; Mt[2][0]=M[0][2];
	Mt[1][2]=M[2][1]; Mt[2][1]=M[1][2];
}
sinline void Mtransponer_fl(const float M[][3], float Mt[][3]){
	Mt[0][0]=M[0][0];	Mt[1][1]=M[1][1];	Mt[2][2]=M[2][2];
	Mt[0][1]=M[1][0]; Mt[1][0]=M[0][1];
	Mt[0][2]=M[2][0]; Mt[2][0]=M[0][2];
	Mt[1][2]=M[2][1]; Mt[2][1]=M[1][2];
}

//Q=MP
#define GiraPuntoM(Q,M,P) \
	(Q).X=M[0][0]*(P).X+M[0][1]*(P).Y+M[0][2]*(P).Z;\
	(Q).Y=M[1][0]*(P).X+M[1][1]*(P).Y+M[1][2]*(P).Z;\
	(Q).Z=M[2][0]*(P).X+M[2][1]*(P).Y+M[2][2]*(P).Z

//Q=M^-1*P
#define GiraPuntoM_inv(Q,M,P) \
	(Q).X=M[0][0]*(P).X; (Q).Y=M[0][1]*(P).X;	(Q).Z=M[0][2]*(P).X;\
	(Q).X+=M[1][0]*(P).Y;	 (Q).Y+=M[1][1]*(P).Y;		(Q).Z+=M[1][2]*(P).Y;\
	(Q).X+=M[2][0]*(P).Z; (Q).Y+=M[2][1]*(P).Z;		(Q).Z+=M[2][2]*(P).Z;

//P=MP
sinline void AutoGiraPunto_dbl(PuntoXYZ_double *P, const double M[][3]){
	PuntoXYZ_double Q=*P;
	P->X=M[0][0]*Q.X+M[0][1]*Q.Y+M[0][2]*Q.Z;
	P->Y=M[1][0]*Q.X+M[1][1]*Q.Y+M[1][2]*Q.Z;
	P->Z=M[2][0]*Q.X+M[2][1]*Q.Y+M[2][2]*Q.Z;
}
sinline void AutoGiraPunto_fl(PuntoXYZ_float *P, const float M[][3]){\
	PuntoXYZ_float Q=*P;
	P->X=M[0][0]*Q.X+M[0][1]*Q.Y+M[0][2]*Q.Z;
	P->Y=M[1][0]*Q.X+M[1][1]*Q.Y+M[1][2]*Q.Z;
	P->Z=M[2][0]*Q.X+M[2][1]*Q.Y+M[2][2]*Q.Z;
}
//P=M^-1*P
sinline void AutoGiraPunto_inv_dbl(PuntoXYZ_double *P, const double M[][3]){
	PuntoXYZ_double Q=*P;
	P->X=M[0][0]*Q.X;	P->Y=M[0][1]*Q.X;	P->Z=M[0][2]*Q.X;
	P->X+=M[1][0]*Q.Y;	P->Y+=M[1][1]*Q.Y;	P->Z+=M[1][2]*Q.Y;
	P->X+=M[2][0]*Q.Z;	P->Y+=M[2][1]*Q.Z;	P->Z+=M[2][2]*Q.Z;
}
sinline void AutoGiraPunto_inv_fl(PuntoXYZ_float *P, const float M[][3]){
	PuntoXYZ_float Q=*P;
	P->X=M[0][0]*Q.X;	P->Y=M[0][1]*Q.X;	P->Z=M[0][2]*Q.X;
	P->X+=M[1][0]*Q.Y;	P->Y+=M[1][1]*Q.Y;	P->Z+=M[1][2]*Q.Y;
	P->X+=M[2][0]*Q.Z;	P->Y+=M[2][1]*Q.Z;	P->Z+=M[2][2]*Q.Z;
}

#define GiraySumaM_dbl(P,M,C) do{PuntoXYZ_double _P_; GiraPuntoM(_P_,M,P); P_op(P,=,_P_,+,C);}while(0)
#define GiraySumaM_inv_dbl(P,M,C) do{PuntoXYZ_double _P_; GiraPuntoM_inv(_P_,M,P); P_op(P,=,_P_,+,C);}while(0)
#define GiraySumaM_fl(P,M,C) do{PuntoXYZ_float _P_; GiraPuntoM(_P_,M,P); P_op(P,=,_P_,+,C);}while(0)
#define GiraySumaM_inv_fl(P,M,C) do{PuntoXYZ_float _P_; GiraPuntoM_inv(_P_,M,P); P_op(P,=,_P_,+,C);}while(0)


/*En las parametrizaciones que emplean ω, φ y κ,el nombre de la funcion indica el orden de
apicación de los giros. Asi, MatrizRotGT_ωφκ calcula la matriz resultado de aplicar primero
el giro ω, luego el giro φ y luego el giro Κ, de los que se pasan en GT.*/

void MatrizRotGT_ωφκ(Giro3DTrig_dbl GT,double M[][3]);	//ω, φ, κ, +

sinline void MatrizRotGT_ωφκ_(Giro3DTrig_dbl GT,double M[][3]){	//ω, φ, κ, -
	GT.sinw=-GT.sinw;
	GT.sinfi=-GT.sinfi;
	GT.sink=-GT.sink;
	MatrizRotGT_ωφκ(GT,M);
}
sinline void MatrizRotGT_κφω(Giro3DTrig_dbl GT,double M[][3]){	//κ, φ, ω, +
	GT.sinw=-GT.sinw;
	GT.sinfi=-GT.sinfi;
	GT.sink=-GT.sink;
	MatrizRotGT_ωφκ(GT,M);
	MinversaRot_dbl(M);
}
sinline void MatrizRotGT_κφω_(Giro3DTrig_dbl GT,double M[][3]){	//κ, φ, ω, -
	MatrizRotGT_ωφκ(GT,M);
	MinversaRot_dbl(M);
}

void MatrizRotGT_κωφ(Giro3DTrig_dbl GT,double M[][3]);	//κ, ω, φ, +

sinline void MatrizRotGT_κωφ_(Giro3DTrig_dbl GT,double M[][3]){	//κ, ω, φ, -
	GT.sinw=-GT.sinw;
	GT.sinfi=-GT.sinfi;
	GT.sink=-GT.sink;
	MatrizRotGT_κωφ(GT,M);
}

//Para esta función GT.cosw, sinw son del primer giro κ; cosfi, sinfi son
//del giro ω , y cosk sink del segundo giro κ.
void MatrizRotGT_κwκ(Giro3DTrig_dbl GT,double M[][3]);	//κ, ω, κ, +

sinline void MatrizRotGT_κwκ_(Giro3DTrig_dbl GT,double M[][3]){	//κ, ω, κ, -
	GT.sinw=-GT.sinw;
	GT.sinfi=-GT.sinfi;
	GT.sink=-GT.sink;
	MatrizRotGT_κwκ(GT,M);
}

sinline void MatrizRot_ωφκ(Giro3D_double G, double M[][3]){
	Giro3DTrig_dbl GT;
	GT.cosw=cos(G.ω);
	GT.sinw=sin(G.ω);
	GT.cosfi=cos(G.φ);
	GT.sinfi=sin(G.φ);
	GT.cosk=cos(G.κ);
	GT.sink=sin(G.κ);
	MatrizRotGT_ωφκ(GT,M);
}
sinline void MatrizRot_ωφκ_(Giro3D_double G,double M[][3]){	//ω, φ, κ, -
	G_eq(G,=-,G);
	MatrizRot_ωφκ(G,M);
}
sinline void MatrizRot_κφω(Giro3D_double G, double M[][3]){
	G_eq(G,=-,G);
	MatrizRot_ωφκ(G,M);
	MinversaRot_dbl(M);
}

void MatrizRot_κωφ(Giro3D_double G, double M[][3]);	//κ, ω, φ, +

sinline void MatrizRot_imu_x(Giro3D_double G, double M[][3]){	//κ-90º, φ, -ω. (ω=Roll, φ=Pitch, κ=Heading)
	G.κ-=PI_2;
	G.ω=-G.ω;
	MatrizRot_κφω(G,M);
}

sinline void MatrizRot_imu_y(Giro3D_double G, double M[][3]){	//κ, -ω, -φ
	G.ω=-G.ω;
	G.φ=-G.φ;
	MatrizRot_κωφ(G,M);
}

//MatrizRot_imu_r(ω,φ,κ)=MatrizRot_imu_y(φ,ω,κ)=MatrizRot_imu_x(ω,φ,κ) + κ(90º)
sinline void MatrizRot_imu_r(Giro3D_double G, double M[][3]){	//κ-90º, φ, -ω, + κ(90º).
	double aux;
	/*MatrizRot_imu_x(G,M);
	aux=M[0][0]; M[0][0]=-M[1][0]; M[1][0]=aux;
	aux=M[0][1]; M[0][1]=-M[1][1]; M[1][1]=aux;
	aux=M[0][2]; M[0][2]=-M[1][2]; M[1][2]=aux;*/
	aux=G.ω;
	G.ω=-G.φ;
	G.φ=-aux;
	MatrizRot_κωφ(G,M);
}

void MatrizRot_24(Giro3D_double G, double M[][3]); //ω, φ, κ (5), +

sinline void MatrizRot_25(Giro3D_double G, double M[][3]){ //ω, φ, κ (5), -
	G_eq(G,=-,G); MatrizRot_24(G,M);
}

sinline void MatrizRot_22(Giro3D_double G, double M[][3]){	//q_1, q_2, q_3, +
	G_mul(G,2.0); MatrizRot_24(G,M);
}
sinline void MatrizRot_23(Giro3D_double G, double M[][3]){ //q_1, q_2, q_3, -
	G_mul(G,-2.0); MatrizRot_25(G,M);
}

/* Esta es MatrizDelta, cuidado con cambiarla */
void MatrizRot_26(Giro3D_double G, double M[][3]); //ω, φ, κ (6), +

sinline void MatrizRot_27(Giro3D_double G, double M[][3]){ //ω, φ, κ (6), -
	G_eq(G,=-,G); MatrizRot_26(G,M);
}

/* MatrizDelta: Crea la matriz de rotación empleando libremente cualquiera de las inter-
pretaciones anteriores, para valores de los giros pequeños. Tiene como función crear
una matriz de rotación válida que en primer orden sea como todas respecto a (ω,φ,κ).
    La versión float devuelve la suma de los cuadrados de las rotaciones; es decir, el módulo
cuadrado de G entendido como un vector. */
float MatrizDeltafl_dbl(Giro3D_float G, double M[][3]);
float MatrizDeltafl_fl(Giro3D_float G, float M[][3]);
#define MatrizDelta_dbl MatrizRot_26

void MatrizRot_28(Giro3D_double G, double M[][3]); //ω, φ, κ (7), +

sinline void MatrizRot_29(Giro3D_double G, double M[][3]){ //ω, φ, κ (7), -
	G_eq(G,=-,G); MatrizRot_28(G,M);
}

void MatrizRot_20(Giro3D_double G, double M[][3]); //a, b, c, +

sinline void MatrizRot_21(Giro3D_double G, double M[][3]){ //a, b, c, -
	G_eq(G,=-,G); MatrizRot_20(G,M);
}
/*** Fin Matrices ***/

sinline Giro3D_double Gmatriz_ωφκ(const double M[][3]){
	Giro3D_double G;
	G.φ=asin(-M[2][0]);
	G.κ=atan2(M[1][0],M[0][0]);
	G.ω=atan2(M[2][1],M[2][2]);
	return G;
}
sinline Giro3D_double Gmatriz_κφω(const double M[][3]){
	Giro3D_double G;
	G.φ=asin(M[0][2]);
	G.κ=atan2(-M[0][1],M[0][0]);
	G.ω=atan2(-M[1][2],M[2][2]);
	return G;
}

sinline Giro3D_double Gmatriz_κωφ(const double M[][3]){
	Giro3D_double G;
	G.ω=asin(-M[1][2]);
	G.φ=atan2(M[0][2],M[2][2]);
	G.κ=atan2(M[1][0],M[1][1]);
	return G;
}

sinline Giro3D_double Gmatriz_imu_x(const double M[][3]){	//κ, φ, -ω
	Giro3D_double G=Gmatriz_κφω(M);
	G.ω=-G.ω;
	return G;
}
sinline Giro3D_double Gmatriz_imu_y(const double M[][3]){	//κ, -ω, -φ
	Giro3D_double G=Gmatriz_κωφ(M);
	G.ω=-G.ω;
	G.φ=-G.φ;
	return G;
}
sinline Giro3D_double Gmatriz_imu_r(const double M[][3]){
	double aux;
	Giro3D_double G=Gmatriz_κωφ(M);
	aux=G.ω;
	G.ω=-G.φ;
	G.φ=-aux;
	return G;
}

Giro3D_double Gmatriz_ωφκ_seg(const double M[][3]);

sinline Giro3D_double Gmatriz_κφω_seg(const double M[][3]){
	Giro3D_double G;
	double Mt[3][3];
	Mtransponer_dbl(M,Mt);
	G=Gmatriz_ωφκ_seg(Mt);
	G_eq(G,=-,G);
	return G;
}
sinline Giro3D_double Gmatriz_κωφ_seg(const double M[][3]){
	double Md[3][3];
	Giro3D_double G;
	double aux;
	Md[0][0]=M[2][2]; Md[2][2]=M[1][1]; Md[1][1]=M[0][0];
	Md[0][1]=M[2][0]; Md[2][0]=M[1][2]; Md[1][2]=M[0][1];
	Md[0][2]=M[2][1]; Md[2][1]=M[1][0]; Md[1][0]=M[0][2];
	G=Gmatriz_ωφκ_seg(Md);
	aux=G.ω; G.ω=G.φ; G.φ=G.κ; G.κ=aux;
	return G;
}

//ω=Roll, φ=Pitch, κ=Heading.
sinline Giro3D_double Gmatriz_imu_x_seg(const double M[][3]){	//κ(κ-90º), φ(φ), ω(-ω)
	Giro3D_double G=Gmatriz_κφω_seg(M);
	G.ω=-G.ω;
	G.κ+=PI_2;
	return G;
}
//ω=Pitch, φ=Roll, κ=Heading.
sinline Giro3D_double Gmatriz_imu_y_seg(const double M[][3]){	//κ(κ), ω(-ω), φ(-φ)
	Giro3D_double G=Gmatriz_κωφ_seg(M);
	G.ω=-G.ω;
	G.φ=-G.φ;
	return G;
}
//ω=Roll, φ=Pitch, κ=Heading.
sinline Giro3D_double Gmatriz_imu_r_seg(const double M[][3]){	//κ, ω(-Pitch), φ(-Roll); e.d., κ(κ), ω(-φ), φ(-ω)
	double aux;
	Giro3D_double G=Gmatriz_κωφ_seg(M);
	aux=G.ω;
	G.ω=-G.φ;
	G.φ=-aux;
	return G;
}

sinline double m01m00_seg(const double M[][3]){
	iflike(fabs(M[0][2])<0.9) return atan2(-M[0][1],M[0][0]);

	double Mt[3][3];
	Giro3D_double G;
	Mtransponer_dbl(M,Mt);
	G=Gmatriz_ωφκ_seg(Mt);
	return -G.κ;
}

sinline Giro3D_double Gmatriz_κwκ(const double M[][3]){
	Giro3D_double G;
	G.φ=acos(M[2][2]);
	G.κ=atan2(M[0][2],-M[1][2]);
	G.ω=atan2(M[2][0],M[2][1]);
	return G;
}
sinline Giro3D_double Gmatriz_κwκ_(const double M[][3]){
	Giro3D_double G;
	G.φ=acos(M[2][2]);
	G.κ=atan2(M[0][2],M[1][2]);
	G.ω=atan2(M[2][0],-M[2][1]);
	return G;
}

Giro3D_double Gmatriz_24_seg(const double M[][3]);

sinline Giro3D_double Gmatriz_26(const double M[][3]){
	Giro3D_double G;
	double p;
	p=1+M[0][0]+M[1][1]+M[2][2];
	p*=0.5;
	G.ω=(M[2][1]-M[1][2])/p;
	G.φ=(M[0][2]-M[2][0])/p;
	G.κ=(M[1][0]-M[0][1])/p;
	return G;
}
sinline void Gmatriz_aprox(const double M[][3], float L[3]){
	L[0]=.5F*(float)(M[2][1]-M[1][2]);
	L[1]=.5F*(float)(M[0][2]-M[2][0]);
	L[2]=.5F*(float)(M[1][0]-M[0][1]);
}
sinline void Gmatriz_aprox_rev(const double M[][3], float L[3]){
	L[0]=.5F*(float)(M[1][2]-M[2][1]);
	L[1]=.5F*(float)(M[2][0]-M[0][2]);
	L[2]=.5F*(float)(M[0][1]-M[1][0]);
}

//Descompone la matriz en 1º (por la derecha): Un giro κ de un múltiplo de 90º
// y 2º: una descomponsición según func en la que el ángulo κ es pequeño.
//En c se devuelve el número de múltiplos de 90º.
Giro3D_double Getoffset_matriz(const double M[][3], Giro3D_double (*func)(const double M[][3]), u8int *c);

sinline void GTrigmatriz_0(const double M[][3],Giro3DTrig_dbl* GT){
	GT->sinfi=-M[2][0];
	GT->cosfi=sqrt(1-GT->sinfi*GT->sinfi);
	GT->cosk=M[0][0]/GT->cosfi;
	GT->sink=M[1][0]/GT->cosfi;
	GT->cosw=M[2][2]/GT->cosfi;
	GT->sinw=M[2][1]/GT->cosfi;
}
sinline void GTrigmatriz_1(const double M[][3],Giro3DTrig_dbl* GT){
	GT->sinfi=M[2][0];
	GT->cosfi=sqrt(1-GT->sinfi*GT->sinfi);
	GT->cosk=M[0][0]/GT->cosfi;
	GT->sink=-M[1][0]/GT->cosfi;
	GT->cosw=M[2][2]/GT->cosfi;
	GT->sinw=-M[2][1]/GT->cosfi;
}
sinline void GTrigmatriz_2(const double M[][3],Giro3DTrig_dbl* GT){
	GT->cosfi=M[2][2];
	GT->sinfi=sqrt(1-GT->cosfi*GT->cosfi);
	GT->sinw=-M[2][0]/GT->sinfi;
	GT->cosw=-M[2][1]/GT->sinfi;
	GT->sink=-M[0][2]/GT->sinfi;
	GT->cosk=M[1][2]/GT->sinfi;
}
sinline void GTrigmatriz_4(const double M[][3],Giro3DTrig_dbl* GT){
	GT->cosfi=M[2][2];
	GT->sinfi=sqrt(1-GT->cosfi*GT->cosfi);
	GT->sinw=M[2][0]/GT->sinfi;
	GT->cosw=M[2][1]/GT->sinfi;
	GT->sink=M[0][2]/GT->sinfi;
	GT->cosk=-M[1][2]/GT->sinfi;
}
sinline void GTrigmatriz_5(const double M[][3],Giro3DTrig_dbl* GT){
	GT->cosfi=M[2][2];
	GT->sinfi=sqrt(1-GT->cosfi*GT->cosfi);
	GT->sinw=M[2][0]/GT->sinfi;
	GT->cosw=-M[2][1]/GT->sinfi;
	GT->sink=M[0][2]/GT->sinfi;
	GT->cosk=M[1][2]/GT->sinfi;
}

//Calcula el giro medio de un array de giros
Giro3D_double Gmedio(const Giro3D_double* giros, uint n);
Giro3D_double Gmedio_pesos(const Giro3D_double* giros, uint n, const Giro3D_float* P);
