#pragma once
#include "COMPILER_resolve.h"
#include "sys_inttypes.h"
/*Memory setting and copying functions and other optimization routines. All these can
be redefined. Functions operating on uint- or double-aligned chunks do better skip the
generic char handling functions (memcpy, memset).
For char8_t and char16_t arrays, avoid memcpy too which checks for alignments and needs
a more elaborate test for the ending. In case they are used for samall arrays they are not important
for the program performance and by avoiding them function calls are replaced by small for loops.
Some systems could provide a very fast way of clearing or setting a block of memory.
    Neither x nor size can include the variable __i. a legal program cannot include variables
prefixed by __. It would be much better that a keyword outer (or another one) could
be prefixed to an identifier to mean "the object referred to by that identifier immediately before
the beginning of the current block", as in
int i; [...] {cint i=outer i; ... }

memset is the only function from string.h, from those that I actually use, required by
this system_C implementation. strcspn might also be needed but this is better programmed
by hand with the actual characters being looked for as constants in the program, as is
done here.
*/
/*Processors have evolved significantly ever since I wrote this file. Functions like memcpy
take advantage of vector registers or ad-hoc processor instructions, thereby being better
than a simple loop also for 4-byte or 8-byte arrays, where we know data is alligned and the
size is the corresponding power of 2 bytes. However, for small pieces of data a simple loop
may still be better, and certainly is for copying small char strings (much less if's and no
function call). In any case, the names of the macros or functions here do not conflict with
those of the standard string.h header. So it is at any rate useful to have these definitions
and the user is free to choose the string.h function or the simple loop from here.
*/
#ifdef COMPILER
#include mergestring(ATmemstr_,COMPILER.h)
#endif
																//"The memset function copies the value of c (converted to an unsigned char) into
#ifndef MEMSET											//each of the first n characters of the object pointed to by s."
	#include <stddef.h> //for size_t
	void* memset(void *s, int c, size_t _size);			//So it should be defined as void* memset(void*, unsigned char val, size_t _size); but they
#endif														//didn't because of the cursed int proselitism; in particular, because character literals are
#ifndef zeroset												//of type int. Because of that, if we want the function to fill a block of memory with
#define zeroset(x,size) memset(x,0,size)				//bits 1, we have to pass the int -1 to the function which, when converted to unsigned char,
#endif														//will yiled the desired result, and not ~0U. In ones'-complement machines the latter is
#ifndef oneset												//undefined behaviour and would at best be reinterpreted to zero, while the former would
#define oneset(x,size) memset(x,-1,size)				//be converted to (unsigned char)-1 which is what we want. This is counter-intuitive
#endif														//since the bits of the number we pass to the function are changed, but such is the result
//																//of the absurd of defining a parameter as int for a function that wants an unsigned value.
#ifndef zeroset_packedbits			//this is for packed bitfields
#define zeroset_packedbits(x,size) {cint __i=size; packedbits* _x=x; while(__i) __i--, *_x++=0;}
#endif
//
#ifndef zeroset_uint
#define zeroset_uint(x,size) memset_uint(x,0,size)
#endif
#ifndef oneset_uint									//set to maximum uint32 value. -1 would also be valid. ~(uint)0
#define oneset_uint(x,size) memset_uint(x,~0U,size)	//would not because of the &$%# promotion to int, even
#endif															// of unsigned operators to which unay operators are applied
#ifndef memset_uint
#define memset_uint(x,value,size) {cint __i=size; uint *_x=(uint*)(x); while(__i) __i--, *_x++=value;}
#endif

#ifndef memcpy_char8
#define memcpy_char8(x,y,size) do{cint __i=size; char8_t *_x=x; const char8_t *_y=y; while(__i) __i--, *_x++=*_y++;}while(0)
#endif
#ifndef memcpy_char16
#define memcpy_char16(x,y,size) do{cint __i=size; char16_t *_x=x; const char16_t *_y=(const char16_t*)(y); while(__i) __i--, *_x++=*_y++;}while(0)
#endif
//
#ifndef memcpy_uint
#define memcpy_uint(x,y,size) {cint __i=size; uint *_x=(uint*)(x); const uint* _y=(const uint*)(y); while(__i) __i--, *_x++=*_y++;}
#endif
#ifndef MEMCMP_UINT	//Intended for small pieces of memory
static inline int memcmp_uint(const uint* u1, const uint* u2, uint n){
	while(n && *u1==*u2) n--, u1++,u2++;
	if(n==0) return 0;
	if(*u1>*u2) return 1;
	return -1;
}
#endif

//array[0-n] <-- array[offset-(n+offset)]     ((n-1) in place of n)
static inline void arrayback_uint(uint* array, uint offset, uint n){
	uint *fwd=array+offset;
	while(n) n--, *array++=*fwd++;
}
//array[0-n] --> array[offset-(n+offset)]     ((n-1) in place of n)
static inline void arrayfwd_uint(uint* array, uint offset, uint n){
	uint *fwd;
	array+=n; fwd=array+offset;
	while(n) n--, *--fwd=*--array;
}

#ifndef arrayback1_uint
#define arrayback1_uint(array,n) {cint __i; uint *_x=array; for(__i=n;__i;){__i--; *_x=*(_x+1); _x++;}}
#define arrayfwd1_uint(array,n) {cint __i; uint *_x=(array)+n; for(__i=n;__i;){__i--; *_x=*(_x-1); _x--;}}
#endif
#ifndef arrayback1
#define arrayback1(Type,array,n) {cint __i; Type *_x=array; for(__i=n;__i;){__i--; *_x=*(_x+1); _x++;}}
#define arrayfwd1(Type,array,n) {cint __i; Type *_x=(array)+n; for(__i=n;__i;){__i--; *_x=*(_x-1); _x--;}}
#endif

//The most common use of moving the array one position foreward is to insert one element
#ifndef arrayinsert1_uint
#define arrayinsert1_uint(array,elem,len) {uint __i; uint *_x=(array)+len; for(__i=len;__i;){__i--; *_x=*(_x-1); _x--;} *_x=elem;}
#endif
#ifndef arrayinsert1_Type
#define arrayinsert1_Type(Type,array,elem,len) {uint __i; Type *_x=(array)+len; for(__i=len;__i;){__i--; *_x=*(_x-1); _x--;} *_x=elem;}
#endif
//
#ifndef NULL_set
#define NULL_set(x,size) {cint __i=size; void** _x=x; while(__i) __i--, *_x++=NULL;}
#endif
#ifndef memcpy_ptr
#define memcpy_ptr(x,y,size) {cint __i=size; void* *_x=(void**)(x); void* const *_y=(void* const *)(y); while(__i) __i--, *_x++=*_y++;}
#endif
//
#ifndef zeroset_bint
#define zeroset_bint(x,size) if(sizeof(bint)==1){zeroset(x,size);} else{cint __i=size; bint* _x=x; while(__i) __i--, *_x++=0;}
#endif
#ifndef oneset_bint
#define oneset_bint(x,size)  if(sizeof(bint)==1){oneset(x,size);} else{cint __i=size; bint* _x=x; while(__i) __i--, *_x++=1;}
#endif
//
#ifndef zeroset_float
#define zeroset_float(x,size) {cint __i=size; float* _x=x; while(__i) __i--, *_x++=0;}
#endif
#ifndef memcpy_float
#define memcpy_float(x,y,size) {cint __i=size; float* _x=x; const float *_y=y; while(__i) __i--, *_x++=*_y++;}
#endif
//
#ifndef zeroset_double
#define zeroset_double(x,size) {cint __i=size; double* _x=x; while(__i) __i--, *_x++=0;}
#endif
#ifndef memcpy_double
#define memcpy_double(x,y,size) {cint __i=size; double* _x=x; const double *_y=y; while(__i) __i--, *_x++=*_y++;}
#endif
//
#ifndef zeroset_AT_fastFloat
#define zeroset_AT_fastFloat(x,size) {cint __i=size; AT_fastFloat* _x=x; while(__i) __i--, *_x++=0;}
#endif

#define memcpyT(Type) merge(memcpy_,Type)
#define zerosetT(Type) merge(zeroset_,Type)
#define onesetT(Type) merge(oneset_,Type)
