﻿#if !defined(AT_ARRAYS_ALL) && !(defined(ATCRT_TYPES_ONLY) && defined(AT_CLASESARRAYS))
//AT_CLASESARRAYS defined at the end of the file
//AT_ARRAYS_ALL defined if !defined(ATCRT_TYPES_ONLY)

#include <malloc.h>
#include <uchar.h>
#ifndef ATCRT_TYPES_ONLY
#include "ATmemstr.h"
#endif

#if !defined(AT_CLASESARRAYS)

#define AT_NOMEM -2 //Aerotri's definition

#define defineArray(type) \
	typedef struct{\
		type* v;	/*n arrays consecutivos*/\
		uint* ppios; /*indica el comienzo o el final de cada array. Pueden ser n o n+1 elems.*/\
	} Array_##type;

#define defineVector(type) \
	typedef struct{	/*No se inicializa. Hay que inciarlo reservando al menos 4*/\
		type* ppio;\
		uint n, N;\
	} Vector_##type;

//Estructura con punteros next, end en lugar de enteros n, N.
//Para cuando estos últimos no son muy imporantes o se van a
//ir añadiendo muchos elementos poco a poco.
#define defineGrowing(type) \
	typedef struct{	/*No se inicializa. Hay que inciarlo reservando al menos 4*/\
		type* ppio;\
		type *next, *end;\
	} Growing_##type;

#endif


#ifndef ATCRT_TYPES_ONLY

#define Vsetup(type,x,NN,nomem_code) \
do{\
	if(NN<4) (x).N=4; else (x).N=NN;\
	(x).ppio=(type*)malloc((x).N*usizeof(type));\
	ifunlike((x).ppio==NULL){(x).N=0; nomem_code;}\
	else (x).n=0;\
}while(0)

#define Vrealloc(x,type,Nr,nomem_code) \
do{\
	void *prov=realloc((x).ppio,Nr*usizeof(type));\
	ifunlike(prov==NULL){nomem_code;}\
	(x).ppio=(type*)prov;\
	(x).N=Nr;\
}while(0)

#define Vadd_operated(x,type,OP_value,nomem_code) \
	do{ifunlike((x).n==(x).N){\
		uint N=(x).N+((x).N>>VectorGrowingFactor);\
		if(N==(x).N) N++;\
		Vrealloc(x,type,N,nomem_code);\
	}\
	(x).ppio[(x).n++] OP_value;\
}while(0)

#define Vadd(x,type,value,nomem_code) Vadd_operated(x,type,=(value),nomem_code);

#define Venlarge_one(x,type,ptr,nomem_code) \
do{\
	ifunlike((x).n==(x).N){\
		uint N=(x).N+((x).N>>VectorGrowingFactor);\
		if(N==(x).N) N++;\
		Vrealloc(x,type,N,nomem_code);\
	}\
	ptr=(x).ppio+(x).n++;\
}while(0)

//This may be used for a few large reservations or for many samall ones. In the first
//scenario a simple if maight be preferred over ifunlike. However, the combination
//of both scenarios makes ifunlike a better default choice. Even if the user's main
//use of the macro is for large reservations, the amount of code needed to execute
//in case the test tests to true makes the ifunlike harmless at worst.
#define Venlarge_n(x,type,nr,nomem_code) \
do{\
	(x).n+=nr;\
	ifunlike((x).n>(x).N){\
		uint N=(x).N+((x).N>>VectorGrowingFactor);\
		if(N<(x).n) N=(x).n;\
		(x).n-=nr; Vrealloc(x,type,N,nomem_code);\
		(x).n+=nr;\
	}\
}while(0)

#define Vreserve_n(x,type,nr,nomem_code) \
do{\
	ifunlike((x).n+nr>(x).N){\
		uint N=(x).N+((x).N>>VectorGrowingFactor);\
		if(N<(x).n+nr) N=(x).n+nr;\
		Vrealloc(x,type,N,nomem_code);\
	}\
}while(0)

#define VectorGrowingFactor 1 //be carefull changing this

#define Vcopia(type,x1,x2) {type *ptr=(x1).ppio, *ptrb=(x2).ppio; for(cint i=(x2).n; i--;*ptr++=*ptrb++);} (x1).n=(x2).n


#define Growing_setup(type,gc,size,nomem_code) \
	(gc).ppio=(type*)malloc((size)*usizeof(type));\
	ifunlike((gc).ppio==NULL){nomem_code;}\
	else{(gc).next=(gc).ppio; (gc).end=(gc).ppio+size;}

#define Grealloc(x,type,n,N,nomem_code) \
do{void *prov=realloc((x).ppio,N*usizeof(type));\
	ifunlike(prov==NULL){nomem_code;}\
	(x).ppio=(type*)prov;\
	(x).next=(x).ppio+nn;\
	(x).end=(x).ppio+N;\
}while(0)

#define Gcheck_realloc(x,type,nomem_code) \
	ifunlike((x).next==(x).end){\
		uint nn,N;\
		N=nn=(pdif)((x).end-(x).ppio);\
		N+=N>>VectorGrowingFactor;\
		if(N==nn) N++;\
		Grealloc(x,type,nn,N,nomem_code);\
	}

#define Gadd_blind(x,value) *(x).next++=value
#define Gadd(x,type,value,nomem_code) \
	do{Gcheck_realloc(x,type,nomem_code) *(x).next++=value;} while(0)

#define Greserve_n(x,type,nr,nomem_code) \
do{ifunlike((x).next+nr>(x).end){\
	uint nn=(pdif)((x).next-(x).ppio);\
	uint N=(pdif)((x).end-(x).ppio);\
	N+=N>>VectorGrowingFactor;\
	if(N<nn+nr) N=nn+nr;\
	Grealloc(x,type,nn,N,nomem_code);\
}}while(0)

//Adds n elements pointed to by ptr and advance ptr n positions
#define Gadd_n(x,type,ptr,n,nomem_code) do{\
	Greserve_n(x,type,n,nomem_code);\
	dontimes(n,ptr++) Gadd_blind(x,*ptr);\
}while(0)

//Se añaden los valores apuntados por ptr hasta llegar a un valor =vlímite.
//El valor vlímite se añade y next queda apuntando a él. También ptr
#define Gadd_advance_delimited(x,type,ptr,vlímite,nomem_code) do{\
	const type *_end=ptr; while(*_end!=vlímite) _end++;\
	Greserve_n(x,type,(pdif)(_end-ptr)+1,nomem_code);\
	while(*ptr!=vlímite) *(x).next++=*ptr++;\
	*(x).next=*ptr;\
}while(0)

//Se añaden los valores apuntados por ptr hasta llegar a un macro_end(valor)!=0.
//El valor 'valor' se añade y next queda apuntando a él. También ptr
#define Gadd_advance_uptoend(x,type,ptr,macro_end,nomem_code) do{\
	const type *_end=ptr; while(!macro_end(*_end)) _end++;\
	Greserve_n(x,type,(pdif)(_end-ptr)+1,nomem_code);\
	while(ptr!=_end) Gadd_blind(x,*ptr++);\
	*(x).next=*ptr;\
}while(0)

//Se añaden los valores apuntados por s hasta llegar a un valor =vlímite.
//El valor vlímite se añade y next queda apuntando a él.
#define Gadd_delimited(x,type,s,vlímite,nomem_code) \
	do{const type *_ptr=s; Gadd_advance_delimited(x,type,_ptr,vlímite,nomem_code);} while(0)

//Se añaden los valores apuntados por ptr hasta llegar a un macro_end(valor)!=0.
//El valor 'valor' se añade y next queda apuntando a él.
#define Gadd_uptoend(x,type,s,macro_end,nomem_code) \
	do{const type *_ptr=s; Gadd_advance_uptoend(x,type,_ptr,macro_end,nomem_code);} while(0)

//Se añaden los valores apuntados por ptr hasta llegar a un valor =vlímite.
//El valor vlímite se añade y next queda apuntando past él.
#define Gadd_limited(x,type,s,vlímite,nomem_code) \
	do{const type *_ptr=s; Gadd_advance_delimited(x,type,_ptr,vlímite,nomem_code); (x).next++;} while(0)

//Macros específicas para Growing_char y Growing_char16_t
#define GC_initialize(gc,size,nomem_code) Growing_setup(char,gc,size,nomem_code); *(gc).ppio='\0'
#define GC_reswitch(gc) (gc).next=(gc).ppio, *(gc).ppio='\0'
#define GC_adds(x,s,nomem_code) Gadd_delimited(x,char,s,'\0',nomem_code)

#define GC8_initialize(gc,size,nomem_code) Growing_setup(char8_t,gc,size,nomem_code); *(gc).ppio='\0'
#define GC8_reswitch(gc) (gc).next=(gc).ppio, *(gc).ppio='\0'
#define GC8_addn(x,ptr,n,nomem_code) Gadd_n(x,char8_t,ptr,n,nomem_code)
//
#define GC8_adds_advance_0(x,ptr,nomem_code) Gadd_advance_delimited(x,char8_t,ptr,'\0',nomem_code)
#define GC8_adds_advance_s(x,ptr,nomem_code) Gadd_advance_delimited(x,char8_t,ptr,' ',nomem_code)
#define GC8_adds_advance_st(x,ptr,nomem_code) Gadd_advance_uptoend(x,char8_t,ptr,is_st,nomem_code)
#define GC8_adds_advance_n(x,ptr,nomem_code) Gadd_advance_delimited(x,char8_t,ptr,'\n',nomem_code)
#define GC8_adds_advance_b(x,ptr,nomem_code) Gadd_advance_uptoend(x,char8_t,ptr,is_stn,nomem_code)
#define GC8_adds_advance_b0(x,ptr,nomem_code) Gadd_advance_uptoend(x,char8_t,ptr,is_stn0,nomem_code)
//
#define GC8_adds(x,s,nomem_code) Gadd_delimited(x,char8_t,s,'\0',nomem_code)
#define GC8_adds_0 GC8_adds
#define GC8_adds_s(x,s,nomem_code) Gadd_delimited(x,char8_t,s,' ',nomem_code)
#define GC8_adds_st(x,s,nomem_code) Gadd_uptoend(x,char8_t,s,is_st,nomem_code)
#define GC8_adds_n(x,s,nomem_code) Gadd_delimited(x,char8_t,s,'\n',nomem_code)
#define GC8_adds_b(x,s,nomem_code) Gadd_uptoend(x,char8_t,s,is_stn,nomem_code)
#define GC8_adds_b0(x,s,nomem_code) Gadd_uptoend(x,char8_t,s,is_stn0,nomem_code)
#define GC8_adds0(x,s,nomem_code) Gadd_limited(x,char8_t,s,'\0',nomem_code)
//The pointer end points to the closing '\0'. There must not be any embedded '\0'
//The closing '\0' is added. x.next queda apuntando a él
#define GC8_adds_end(x,s,end,nomem_code) do{\
	Greserve_n(x,char8_t,(pdif)((end)-(s))+1,nomem_code);\
	for(const char8_t *_ptr=s;*_ptr!='\0';_ptr++) *(x).next++=*_ptr;\
	*(x).next='\0';\
}while(0)

#define GC16_initialize(gc,size,nomem_code) Growing_setup(char16_t,gc,size,nomem_code); *(gc).ppio=u'\0'
#define GC16_reswitch(gc) (gc).next=(gc).ppio, *(gc).ppio=u'\0'
#define GC16_addn(x,ptr,n,nomem_code) Gadd_n(x,char16_t,ptr,n,nomem_code)
//
#define GC16_adds_advance_0(x,ptr,nomem_code) Gadd_advance_delimited(x,char16_t,ptr,'\0',nomem_code)
#define GC16_adds_advance_s(x,ptr,nomem_code) Gadd_advance_delimited(x,char16_t,ptr,' ',nomem_code)
#define GC16_adds_advance_st(x,ptr,nomem_code) Gadd_advance_uptoend(x,char16_t,ptr,is_st,nomem_code)
#define GC16_adds_advance_n(x,ptr,nomem_code) Gadd_advance_delimited(x,char16_t,ptr,'\n',nomem_code)
#define GC16_adds_advance_b(x,ptr,nomem_code) Gadd_advance_uptoend(x,char16_t,ptr,is_stn,nomem_code)
#define GC16_adds_advance_b0(x,ptr,nomem_code) Gadd_advance_uptoend(x,char16_t,ptr,is_stn0,nomem_code)
//
#define GC16_adds(x,s,nomem_code) Gadd_delimited(x,char16_t,s,u'\0',nomem_code)
#define GC16_adds_0 GC16_adds
#define GC16_adds_s(x,s,nomem_code) Gadd_delimited(x,char16_t,s,' ',nomem_code)
#define GC16_adds_st(x,s,nomem_code) Gadd_uptoend(x,char16_t,s,is_st,nomem_code)
#define GC16_adds_n(x,s,nomem_code) Gadd_delimited(x,char16_t,s,'\n',nomem_code)
#define GC16_adds_b(x,s,nomem_code) Gadd_uptoend(x,char16_t,s,is_stn,nomem_code)
#define GC16_adds_b0(x,s,nomem_code) Gadd_uptoend(x,char16_t,s,is_stn0,nomem_code)
#define GC16_adds0(x,s,nomem_code) Gadd_limited(x,char16_t,s,'\0',nomem_code)
//The pointer end points to the closing '\0'. There must not be any embedded '\0'
//The closing '\0' is added. x.next queda apuntando a él
#define GC16_adds_end(x,s,end,nomem_code) do{\
	Greserve_n(x,char16_t,(pdif)((end)-(s))+1,nomem_code);\
	for(const char16_t *_ptr=s;*_ptr!='\0';_ptr++) *(x).next++=*_ptr;\
	*(x).next='\0';\
}while(0)

#endif

#if !defined(AT_CLASESARRAYS)

//Este fichero define ya las estructuras más comunes
defineArray(umint)
defineArray(uint)
defineVector(uint)
defineGrowing(char)
defineGrowing(char8_t)
defineGrowing(char16_t)
defineGrowing(uint)

#endif


/*********************************  HASH  ***************************************\

Macro para crear una Hash. Como el preprocesador de C no permite macros que definan otras macros
esto es mucho más complicado de lo que podría ser, y tal macro no existe. No obstante, las hash más
comunes están definidas más abajo. Véase tras las definiciones las explicaciones acerca de cómo definir
y usar una hash de un cierto tipo.*/

#ifndef ATCRT_TYPES_ONLY

#define Hsetup(htype,x,n,field,empty_val,nomem_code) \
do{\
	if(n<4) (x).umbral=4; else (x).umbral=n;\
	(x).last_full=(x).umbral+(((x).umbral)>>2);\
	Vsetup(htype,x,(x).last_full,nomem_code);\
	htype *_phtype=(x).ppio;\
	for(cint _ifillhash=(x).N;_ifillhash!=0;_phtype++){ _ifillhash--;\
		_phtype->field=empty_val; _phtype->next=Я;\
	}\
}while(0)

//Hsetup for the case the representation of empty values is all bits to 1.
#define HsetupЯ(htype,x,n,nomem_code) \
do{\
	if(n<4) (x).umbral=4; else (x).umbral=n;\
	(x).last_full=(x).umbral+(((x).umbral)>>2);\
	Vsetup(htype,x,(x).last_full,nomem_code);\
	oneset_uint((x).ppio,(x).N*uintsizeof(htype))\
}while(0)

//Hsetup for the case empty_val is NULL
#define HsetupNULL(htype,x,n,field,nomem_code) Hsetup(htype,x,n,field,NULL,nomem_code)

#define Hval_setup(htype,x,n,empty_val,nomem_code) Hsetup(htype,x,n,val,empty_val,nomem_code)
#define Hval_setupЯ(htype,x,n,nomem_code)			HsetupЯ(htype,x,n,nomem_code)
#define Hval_setupNULL(htype,x,n,nomem_code)		Hsetup(htype,x,n,val,NULL,nomem_code)
#define Hkey_setup(htype,x,n,empty_key,nomem_code) Hsetup(htype,x,n,key,empty_key,nomem_code)
#define Hkey_setupЯ(htype,x,n,nomem_code)			HsetupЯ(htype,x,n,nomem_code)
#define Hkey_setupNULL(htype,x,n,nomem_code)	Hsetup(htype,x,n,key,NULL,nomem_code)

#define Hcopia(htype,x1,x2) {htype *ptr=(x1).ppio, *ptrb=(x2).ppio; x1=x2; (x1).ppio=ptr; for(cint i=(x2).N; i--;*ptr++=*ptrb++);}

//Funciones de hash muy comunes
#define funchash_uint(n,umbral) ((n)%umbral)
#define funchash_pointer(p,umbral) (((uintptr_t)p>>3)%umbral) //Pointers may be aligned. In case they are not, dividing by 8 does not harm
static inline uint funchash_string8(const char8_t *nom,uint umbral){
	uint n=0;
	while(*nom!='\0'){n<<=2; n+=*nom++; while(n>=umbral) n-=umbral;}
	return n;
}
static inline uint funchash_string16(const char16_t *nom,uint umbral){
	uint n=0;
	while(*nom!=u'\0'){n<<=2; n+=*nom++; while(n>=umbral) n-=umbral;}
	return n;
}

#define addh_val(htype,hash,x,nomem_code) \
	do{htype _pm={x,Я}; ifunlike(merge(addh_,htype)(hash,&_pm)==AT_NOMEM){nomem_code;}}while(0)

#define addh_keydata(htype,hash,key,data,nomem_code) \
	do{htype _pm={key,Я,data}; ifunlike(merge(addh_,htype)(hash,&_pm)==AT_NOMEM){nomem_code;}}while(0)

#define geth_val(htype,hash,val) merge(gethval_,htype)(hash,val)
#define geth_data(htype,hash,key) merge(gethdata_,htype)(hash,key)


#if 0
/*Se crea una Hash de un cierto tipo incluyendo el fichero "hash.cod". Antes de su inclusión tiene que definirse:

	Una estructura que será el tipo de cada uno de los elementos de la hash: <htype>
	El nombre: <keyfield>, y el tipo: <field_type>, del elemento de la estructura que actúa como clave. Además
la estructura debe tener un campo   uint next, literalmente.
	field_value_EMPTY: habrá de ser una expresión de tipo <field_type>.
	funchash: una función de la forma uint funchash(<field_type> nom, uint umbral) o macro equivalente.

El valor devuelto por funchash tiene que ser menor que umbral. El valor devuelto puede depender de
umbral, porque cuando hay que ampliar la hash y ese valor se cambia todos los elementos presentes se realojan
de acuerdo al nuevo valor que proporciona funchash según el nuevo valor de umbral.*/

//Sería así si existiese #begindef #enddef:
//#begindef defineHash(_htype,_field_type,_keyfield,empty_val,_funchash)

//Pero no existe, así que cópiese esto directamente, sustituyendo hpunto, nom, uint,
//AT_NODATA y funchash_uint por la estructura de hash, el campo clave, su tipo,
//el valor vacío y la función de hash.

#define htype hpunto
#define field nom
#define field_type uint
#define field_value_EMPTY AT_NODATA
#define funchash funchash_uint
#include "hash.cod"
#undef htype
#undef field
#undef field_type
#undef field_value_EMPTY
#undef funchash

//#enddef //Correspondiente al supuesto #begindef

/*Si se quiere que la comparación de los campos field, de tipo field_type sea distinta que el simple
== y != deben definirse las macros*/
Hash_isfield_equal(field1,field2,h)
Hash_isfield_not_equal(field1,field2,h)
//field_value_EMPTY no se ve afectado por esto. Siempre se usa == o !=.
/*h es un puntero a la hash. Puede no emplearse, o puede ser que h contenga variables globales
para la hash que sea necesario emplear para poder llevar a cabo la comparación.
Para poder incluir esas variables globales en la hash ha de definirse HASH_GLOBALS antes de incluir
hash.cod o hash_decl.h. Véase hash_index8data.cod.*/
//Si además se necesita cambiar esta comparación con field_value_EMPTY, defínase
Hash_isfield_empty(field)
//Por ejemplo
#define Hash_isfield_empty(field) (field).n==0

/*El fichero hash.cod creará la estructura de hash y tres funciones para el ususario más tres funciones de
uso en principio interno pero que también se pueden usar. La firma de cada una de esas funciones así
como la estructura es*/

typedef struct Hash_<htype>;

<htype>* geth_<htype>(Hash_<htype> *hash, <field_type> nom);
int addh_<htype>(Hash_<htype> *hash, <htype> *p);  //Puede devolver 0 o AT_NOMEM
void removeh_<htype>(Hash_<htype> *hash, <htype> *p);

//Si la estructura de tipo <htype> es de alguna de las dos siguientes formas:

struct{
	<valtype> val;
	uint next;
}

struct{
	<keytype> key;
	uint next;
	<datatype> data;
}

//se puede crear el tipo de Hash y las funciones como se ejemplifica aquí con hUnTipo
//y huintConfigTipo.

#define UNTIPO_NULL (UnTipo){NULL,Я,Я,0}
#define valtype UnTipo
#define field_value_EMPTY  UNTIPO_NULL
#define funchash(x,umbral)  funchash_string8((x).name,umbral)
#define Hash_isfield_empty(field) (field).name==NULL
#define Hash_isfield_equal(field1,field2,h) (field1).name==(field2).name
#define Hash_isfield_not_equal(field1,field2,h) (field1).name!=(field2).name
#define
#include "hash_val.cod"
#undef Hash_isfield_empty
#undef Hash_isfield_equal
#undef Hash_isfield_not_equal

#define keytype uint
#define datatype ConfigTipo
#define field_value_EMPTY Я
#define funchash funchash_uint
#include "hash_keydata.cod"

//Esto creará, en el primer caso, las estructuras

typedef struct _hUnTipo{
	UnTipo val;
	uint next;
} hUnTipo;

typedef struct{/* ... */} Hash_hUnTipo;

//y en el segundo:

typedef struct _huintConfigTipo{
	uint key;
	uint next;
	ConfigTipo data;
} huintConfigTipo;

typedef struct{/* ... */} Hash_huintConfigTipo;

//Además

/*Si se quiere que el nombre de la estructura que se define no sea h<valtype> o
h<keytype><datatype> se definirá htype al nombre que se desea. Esto es necesario siempre
que el tipo <valtype>, <keytype> o <datatype> no sea simplemente una palabra. Por ejemplo*/

#define valtype void*
#define htype hPointer
//...

#define datatype const Config
#define htype hConfig
//...

/*Puesto que un caso muy común de la hash de tipo key/data es que key sea un entero existe
el fichero "hash_uintdata.cod" que simplifica la definición de la hash para esos casos. Para
ConfigTipo se emplearía como sigue. Nótese que se define htype a hConfigTipo para obtener
un nombre más sencillo que el que por defecto se generaría, que sería huintConfigTipo:*/

#define htype hConfigTipo
#define datatype ConfigTipo
#include "hash_uintdata.cod"

//El fichero "hash_uintdata.cod" emplea como valor vacío AT_NODATA, que es ((uint)-1),
//y como función de hash funchash_uint.

/*Para usar una hash de estos elementos se puede llamar a las macros de hash con
htype igual a <htype>, que si no se especificó ninguno es h<elemtype> o h<valtype>.
e.g.:*/

void *q;
ConfigTipo p;
Hash_hPointer hash_handlers; //defined with <valtype> =void*
Hash_hConfigTipo hash_configs;
//...
addh_val(hPointer,&hash_handlers,q,return AT_NOMEM);
addh_keydata(hConfigTipo,&hash_configs,10,p,return AT_NOMEM);

/*También definen getval_data(htype,hash_address,val) y geth_data(htype,hash_address,key),
que devuelven &val y &data si el valor val o la clave key respectivamente están en la hash, si no NULL.
(hash.cod define geth_htype que devuelve un htype*)*/

Hash_hConfigTipo hash1;
ConfigTipo *pCT;
//...
pCT=geth_data(hConfigTipo,&hash1,10);
if(pCT==NULL){
	//El elemento 10 no está en la hash
}else{
	//El elemento 10 está en la hash
}
#endif

#endif //ATCRT_TYPES_ONLY

/* ************************* Fin de las explicaciones. ********************** *\
 * -----------------      Definiciones de Hash comunes      -------------------*/

#ifndef mergestring
	#define _makestring(s) #s
	#define _merge(a,b) a##b
	#define _mergestring(a,b) _makestring(a##b)
	#define merge(a,b) _merge(a,b)
	#define mergestring(a,b) _mergestring(a,b)
#endif

#ifdef ATCRT_TYPES_ONLY
#define ATHASH_TYPES_ONLY //Undefined at the end
#elif defined(AT_CLASESARRAYS)
#define HASH_ALREADY_DECL
#endif

#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-function"
#elif defined(__GNUC__)
#pragma GCC diagnostic push "-Wunused-function"
#pragma GCC diagnostic ignored "-Wunused-function"
#endif

//Hash basadas en hash_val

#define valtype uint
#define funchash funchash_uint
#define field_value_EMPTY Я
#define HASH_EMPTY_IS_Я	//Not essential. Could be omited
#include "hash_val.cod"
#undef HASH_EMPTY_IS_Я

#define htype hPointer /*Pointers will be compared verbatim for equality (i.e., not their contents)*/
#define valtype void*
#define field_value_EMPTY NULL
#define funchash funchash_pointer
#include "hash_val.cod"

#define Hash_isfield_equal(s1,s2,h) (s1!=field_value_EMPTY && strcmp8(s1,s2)==0)
#define Hash_isfield_not_equal(s1,s2,h) (s1==field_value_EMPTY || strcmp8(s1,s2)!=0)
#define htype hString8
#define valtype const char8_t*
#define field_value_EMPTY NULL
#define funchash funchash_string8
#include "hash_val.cod"
#undef Hash_isfield_equal
#undef Hash_isfield_not_equal

#ifndef ATCRT_TYPES_ONLY
#define HsetupPointer(hash,n,nomem_code) HsetupNULL(hPointer,hash,n,val,nomem_code)
#define HsetupString8(hash,n,nomem_code) HsetupNULL(hString8,hash,n,val,nomem_code)
#define addh_huint(hash,n,nomem_code) addh_val(huint,hash,n,nomem_code)
#define addh_hPointer(hash,ptr,nomem_code) addh_val(hPointer,hash,ptr,nomem_code)
#define addh_hString8(hash,s,nomem_code) addh_val(hString8,hash,s,nomem_code)
#endif

// Hash basadas en hash_keydata

#define htype hPtrUint
#define keytype void*
#define datatype uint
#define field_value_EMPTY NULL
#define funchash funchash_pointer
#include "hash_keydata.cod"

#define htype hUintStr8
#define datatype char8_t*
#include "hash_uintdata.cod"

#define htype hUintUint
#define datatype uint
#include "hash_uintdata.cod"

#define htype hStr8Uint
#define datatype uint
#include "hash_str8data.cod"

#define htype hStr8Str8
#define datatype char8_t*
#include "hash_str8data.cod"

#define htype hBase8Uint
#define datatype uint
#include "hash_base8data.cod"

#ifdef __clang__
#pragma clang  diagnostic pop
#elif defined(__GNUC__)
#pragma gcc  diagnostic pop
#endif

#ifndef ATCRT_TYPES_ONLY
#define HsetupUint(hash,n,nomem_code) HsetupЯ(huint,hash,n,nomem_code)
#define HsetupPointer(hash,n,nomem_code) HsetupNULL(hPointer,hash,n,val,nomem_code)
#define HsetupPtrUint(hash,n,nomem_code) HsetupNULL(hPtrUint,hash,n,key,nomem_code)
#define HsetupUintStr8(hash,n,nomem_code) HsetupЯ(hUintStr8,hash,n,nomem_code)
#define HsetupUintUint(hash,n,nomem_code) HsetupЯ(hUintUint,hash,n.nomem_code)
#define HsetupStr8Uint(hash,n,nomem_code) HsetupNULL(hStr8Uint,hash,n,key,nomem_code)
#define HsetupStr8Str8(hash,n,nomem_code) HsetupNULL(hStr8Str8,hash,n,key,nomem_code)
#define HsetupBase8Uint(hash,base_ptr,n,nomem_code) HsetupЯ(hBase8Uint,hash,n,nomem_code); (hash).base=&(base_ptr)
#endif

#undef ATHASH_TYPES_ONLY
#undef HASH_ALREADY_DECL

#if 0

    Si se quiere exponer la definición de la estructura de Hash en un fichero de cabecera, pero
sin incluir el código que define las funciones, tras la definición o declaración de la estructura
htype ha de incluirse hash_decl.h en lugar de hash.cod. En el módulo que emplee la Hash, si
se incluye dicho fichero de cabecera, antes de incluir hash.cod hay que definir
HASH_ALREADY_DECL. Por ejemplo

/******* mimodulo.h *******/

typedef struct hUintStr16;
#define htype hUintStr16
#include "hash_decl.h"

typedef struct{
	char8_t* nombre;
	float foo;
	Hash_hUintStr16 bar;
	uint otrosdatos[40];
} UnaEstructura;

/******* mimodulo.c *******/

#include "mimodulo.h"

#define htype hUintStr16
#define datatype char16_t*
#define HASH_ALREADY_DECL
#include "hash_uintdata.cod"
#undef HASH_ALREADY_DECL

/*Mientras los del comité del lenguaje C no se den cuenta de que permitir re-typedef's
idénticos es muy útil. Más aún un operador _IfDefined(<type>). */

#endif


#define AT_CLASESARRAYS
#if !defined(ATCRT_TYPES_ONLY)
	#define AT_ARRAYS_ALL
#endif

#endif
