#include "COMPILER_resolve.h"
#include "AT_filenames.h"
#include "shrt_path.h"
#include "ATuint.h"
#include <uchar.h>

#if SYSTEM_ID == 90 //None of the systems known by this library has 0 here
	#define ARGV0_IS_PROGNAME 0
#else
	#define ARGV0_IS_PROGNAME 1
#endif

/*Copia el argumento (normalmente una ruta) que comienza en la palabra apuntada por argv
a fout. Si la palabra no empieza por " es esa palabra sola. En caso contrario puede extenderse
por varias palabras de argv. Ej.: "fichero de entrada" (3 palabras). Esta función junta las piezas,
guarda el resultado fout y avanza argv.

_pend: Si no es NULL, se guarda aquí un puntero al '\0' del final del argumento en fout.

Return:
	0: Todo bien
	1: No hay una comilla de cierre correspondiente a la comilla " de apertura.
	2: Cadena vacía: Una comilla de apertura y nada más sigue en la línea de comandos

Restricciones: *argv no puede ser NULL.
				Se supone que el resultado cabrá en fout.

    Si no hay una comilla de cierre correspondiente al " de apertura se interpreta que estaría ese " que falta
al final de toda lo escrito en la línea de comandos (por tanto, la ruta ha consumido todo argv).
    Si tras la ruta ya no hay nada más en argv, este quedará apuntado al NULL del final.
    Es posible que tras llamar a la función sea fout[0]='\0' y el valor devuelto sea 0. Esto sucede si
se especifica "" (una palabra) o " " (en dos palabras separadas). También si (*argv)[0]='\0'.
*/
int cmdline_compose8(char8_t const *const **argv, char8_t fout[SHRT_PATH], char8_t **_pend);
int cmdline_compose16(char16_t const *const **argv, char16_t fout[SHRT_PATH], char16_t **_pend);

#if FILE_PREFERRED_ENCODING==FILE_ENCODING_BIT8
	#define cmdline_compose cmdline_compose8
#else
	#define cmdline_compose cmdline_compose16
#endif
