/*
Explicación de los distintos módulos que componen ATcrt. Se pueden incluir
individualmente. Los marcados con //* contienen definiciones de funciones cuyo
código se encuentra dentro de la librería ATcrt; es decir, son propiamente los
módulos que componen esa librería. Los demás se pueden emplear independien-
temente de ella.
*/

/*Garbage collector y, en debug, almacena el nombre de la variable de cada puntero
añadido a la lista, de modo que si en una liberación de memoria la comprobación
de tiempo de ejecución insertada por el compilador en modo debug arroja un error,
podemos fácilmente ver de qué variable se trata.
    Este módulo no depende de ATsystem.h, y es el único así.*/
#ifndef ATCRT_TYPES_ONLY
#include "ATmem.h"  //*
#endif

/* This implementation provides files called warnings_<COMPILER>.h for several COMPILERs.
They are not included here because the configuration of warnings and errors is a very
personal decision, but you may use the file provided here by including it via a command
line option for you compiler or otherwise.*/

/*Contiene definiciones esenciales, empeadas por la mayoría de los archivos .h que siguen,
si bien para muchos basta AT_inttypes.h, que este incluye. */
#include "ATsystem.h"

/*_likely and _unlikely for branching optimization, and the iflke and ifunlike shortcuts.
Macros de reserva de memoria, check return value y añadir a un PLIST de ATcrt.h.
Macros para recorrer arrays y alguna utilidad más. Solamente contiene definiciones
de macros. Algunas al expandirse necesitarán las definiciones de ATsystem.h, otras no.*/
#ifndef ATCRT_TYPES_ONLY
#include "ATmacros.h"
#endif

/*Visibility of identifiers from the compile module to other modules / code. The concept
of "visible to other programs" is by no means implementation or system dependent, but
there is no standard. This therefore need hand crafted definitions in the different
ATvisibility_<COMPILER>.h files.*/
#ifndef ATCRT_TYPES_ONLY
#include "ATvisibility.h"
#endif

/*Utilites for function prototypes: const for double pointers, _unused and LARGE_STACK.*/
#ifndef ATCRT_TYPES_ONLY
#include "ATfunctions.h"
#endif

/*Fixed point types. Small integer types that represent a number between 0 and 1
(typically). The number is holded in a uint8m or a uint16m (typically, 8- and 16- bit
unsigned type). Several macros are provided for operating them.*/
#include "ATfixedpoint.h"

/*Handling of individual bytes in integers and of chars uint-packed chars. Intended
mostly for I/O.*/
#ifndef ATCRT_TYPES_ONLY
#include "ATbytes.h"
#endif

/*Utilities for floating point numbers*/
#ifndef ATCRT_TYPES_ONLY
#include "ATfputils.h"
#endif

/*Macros mineq, etc. for a=min(a,b), etc. Macros divup, divMed, divmed.*/
#ifndef ATCRT_TYPES_ONLY
#include "ATminmaxdiv.h"
#endif

/*Memory setting, copying and comparison functions. Also includes the moving
of an array fwd or bkw one position, and the insertion of an element there.*/
#ifndef ATCRT_TYPES_ONLY
#include "ATmemstr.h"
#endif

/*Varios tipos de Arrays de expansión dinámica: Vector, Growing y Hash.*/
#include "ATarrays.h"

/* Copia de unos strings en otros, con conversión entre strings de char8_t y de char16_t.
Lectura de strings (terminados en '\0', ' ', '\t' o '\n') para su conversión en enteros o
floating-point, escritura de un uint en un string. */
#ifndef ATCRT_TYPES_ONLY
#include "ATstring.h"  //*
#endif

/* Definiciones relativas a la sintaxis de los paths en el sistema, y funciones que los
manejan. Las definiciones se encuentran en
"path_definitions_<SYSTEM>.h"
*/
#ifndef ATCRT_TYPES_ONLY
#include "ATpaths.h"  //*
#endif

/*Lectura de ficheros. Se carga todo el archivo a memoria en una única lectura.
Para los archivos binarios no se hace nada más. Los archivos de texto se leen mediante
macros, y de estas las que leen una palabra reciben entre sus argumentos el nombre
de la función a la que se le pasará la palabra y el de la variable en donde se almacenará
el resultado devuelto por la función. Predefine algunas macros que aprovechan las
funciones de ATstring.h. */
#include "ATfileinput.h"  //*

/*Escritura de ficheros de texto y binarios. Incluye un falso fichero de salida de texto,
ATFormatter, que funciona como un buffer en el que se puede convertir a string forma-
teándolos una pequeña serie de datos.*/
#include "ATfileoutput.h"  //*

/*Funciones que inspeccionan el sistema de archivos de la máquina de tiempo de
ejecución y obtienen rutas específicas del sistema.*/
#ifndef ATCRT_TYPES_ONLY
#include "ATfiles.h"  //*
#endif

/* An extension to the preprocessor such as
#begindef macro(a,b,c,d)
<lines, including preprocessor directives>
#enddef
would simplify some constructions. Notably, the declaration and definition of hash's.
*/
