#include <io.h>
#include <fcntl.h>
#include <errno.h>
#define FUNCTION_open_tfile8
#define FUNCTION_open_tfile16
#define FUNCTION_open_bifile

int makebuffer_from(Bufferti8 *buf, int i){
	char8_t* pc;
	uint k=_filelength(i);
	ifunlike(k==Я){_close(i); return ATFILEI_UNKNOWN;}
	ifunlike(k>=ATFILEI_MAXSIZE){_close(i); return ATFILEI_LARGEFILE;}

	k+=5, k|=3, k++;		//k+6, redond. arriba
	buf->vbase=malloc(k);
	ifunlike(buf->vbase==NULL){_close(i); return AT_NOMEM;}
	buf->pc=pc=(char8_t*)buf->vbase+4;

	k=(uint)_read(i,pc,k-5);
	*(pc-1)='\n';
	if(_unlikely(k==0) || pc[k-1]!='\n') pc[k++]='\n';	/*so that strchr(buffer.pc,'\n') and str_stn(buffer.pc) never return NULL*/
	pc[k]='\0';
	_close(i);
	buf->next=pc-1;
	return (int)k;
}
int code_from_errno(void){
	if(errno==ENOENT) return ATFILEI_NOFILE;
	if(errno==EMFILE) return ATFILEI_NOMORE;
	if(errno==EACCES) return ATFILEI_NOTALLOWED;
	return ATFILEI_UNKNOWN;
}
int tiopen8(Bufferti8 *buf, const char8_t* fichero){
	int i;
	i=_open(fichero,_O_RDONLY|_O_TEXT|_O_SEQUENTIAL);
	ifunlike(i==-1){buf->vbase=NULL; return code_from_errno();}
	return makebuffer_from(buf,i);
}
int tiopen_mixed(Bufferti8 *buf, const char16_t* fichero){
	int i;
	i=_wopen(fichero,_O_RDONLY|_O_TEXT|_O_SEQUENTIAL);
	ifunlike(i==-1){buf->vbase=NULL; return code_from_errno();}
	return makebuffer_from(buf,i);
}
int tiopen16(Bufferti16 *buf, const char16_t* fichero){
	char16_t* pc;
	int i;
	uint k;
	i=_wopen(fichero,_O_RDONLY|_O_U16TEXT|_O_SEQUENTIAL);

	ifunlike(i==-1){buf->vbase=NULL; return code_from_errno();}
	k=_filelength(i);
	ifunlike(k==Я){_close(i); return ATFILEI_UNKNOWN;}
	ifunlike(k>=ATFILEI_MAXSIZE/usizeof(char16_t)){_close(i); return ATFILEI_LARGEFILE;}

	k+=4 +usizeof(char16_t)+usizeof(char16_t);	//u'\n', u'\0'
	k+=3, k&=~3U;
	buf->vbase=malloc(k);
	ifunlike(buf->vbase==NULL){_close(i); return AT_NOMEM;}
	buf->pc=pc=(char16_t*)((char8_t*)buf->vbase+4);

	k=(uint)_read(i,pc,k-4-usizeof(char16_t));
	k/=usizeof(char16_t);
	*(pc-1)=u'\n';
	if(*pc==0xFFFE || *pc==0xFEFF) *pc=u'\n';

	if(_unlikely(k==0) || pc[k-1]!=u'\n') pc[k++]=u'\n';	/*so that wcschr(buffer.pc,u'\n') and _wstr_stn(buffer.pc) never return NULL*/
	pc[k]=u'\0';
	_close(i);
	buf->next=pc-1;
	return (int)k;
}

int read_bifile(uint* *buf, int i){
	long l;
	uint k;
	l=_filelength(i);
	ifunlike(l==-1){_close(i); return ATFILEI_UNKNOWN;}
	ifunlike(l>ATFILEI_MAXSIZE){_close(i); return ATFILEI_LARGEFILE;}

	k=((uint)l+usizeof(uint)-1)/usizeof(uint);
	*buf=(uint*)malloc(k*usizeof(uint));
	ifunlike(*buf==NULL){_close(i); return AT_NOMEM;}
	(*buf)[k-1]=0;
	l=_read(i,*buf,l);
	_close(i);
	return (int)k;
}
int biopen8(uint* *buf, const char8_t* fichero){
	int i;
	i=_open(fichero,_O_RDONLY|_O_BINARY|_O_SEQUENTIAL);
	ifunlike(i==-1) return code_from_errno();
	return read_bifile(buf,i);
}
int biopen16(uint* *buf, const char16_t* fichero){
	int i;
	i=_wopen(fichero,_O_RDONLY|_O_BINARY|_O_SEQUENTIAL);
	ifunlike(i==-1) return code_from_errno();
	return read_bifile(buf,i);
}
