#include "../include/ATstrconv.h"

//#includeif mergestring(openflushclose_,SYSTEM.c)
#if defined(_WIN32)
#include mergestring(openflushclose_,SYSTEM.c)
#endif

#ifndef IGNORE_ALL
#include <stdio.h>
//Los tamaños van en 4-bytes
//BufSize must be a multiple of 2^8
//extra_size*sizeof(uint) tiene que ser por lo menos 520
#ifndef BufSize
	#define BufSize 010000
#endif
#ifndef to_EXTRASIZE
	#define to_EXTRASIZE 0400
#endif

#ifndef FUNCTION_bufsetup
static int bo_setup_buffer(Buffer_bo *buf){
	buf->base=NULL;
	ifunlike(buf->id==ID_NOFILE) return ATFILEO_OPEN_UNKNOWN;
	buf->base=(uint*)malloc(BufSize*usizeof(uint));
	ifunlike(buf->base==NULL){
		fclose((FILE*)buf->id);
		buf->id=ID_NOFILE;
		return AT_NOMEM;
	}
	buf->top=buf->base+BufSize;
	buf->ptr=buf->base;
	buf->error_code=0;
	return 0;
}
#endif

#if !defined(FUNCTION_boopen) || !defined(FUNCTION_toopen_mixed) || !defined(FUNCTION_toopen16)
#include "../include/ATstring.h"
//extern int mbstring___c16string(char8_t* sb, const char16_t* s16);
#endif

#ifndef FUNCTION_boopen
int boopen16(Buffer_bo *buf, const char16_t* fichero, u8int endianness){
	char8_t* filename_c;
	int k=stru8___str16(NULL,fichero);
	ifunlike(k==-1){
		buf->id=ID_NOFILE;
		return ATFILEO_OPEN_BADPATH;
	}
	filename_c=(char8_t*)malloc((uint)k*usizeof(char8_t));
	ifunlike(filename_c==NULL){
		buf->id=ID_NOFILE;
		return AT_NOMEM;
	}
	stru8___str16(filename_c,fichero);

	k=boopen8(buf,filename_c,endianness);
	free(filename_c);
	return k;
}
#endif
#ifndef FUNCTION_boopen_c
int boopen8(Buffer_bo *buf, const char8_t* fichero, u8int endianness){
	buf->id=(uintptr_t)(void*)fopen(fichero,"wb");
	buf->endian=endianness;
	return bo_setup_buffer(buf);
}
#endif

#ifndef FUNCTION_to_setup_buffer
static int to_setup_buffer(BuffertoGeneric *buf, uint size, uint extra_size, u8int SIZE){
	if(extra_size*usizeof(uint)<560*SIZE) extra_size=560*SIZE/usizeof(uint);
	buf->base=(char8_t*)malloc((size+extra_size)*usizeof(uint));
	ifunlike(buf->base==NULL){
		fclose((FILE*)buf->id);
		buf->id=ID_NOFILE;
		return AT_NOMEM;
	}
	buf->top=buf->base+size*usizeof(uint);
	buf->ptr=buf->base;
	buf->backPtr=buf->top+(extra_size-1)*usizeof(uint);
	*(uint*)buf->backPtr=0;
	buf->backPtr-=SIZE;
	buf->flushedchars=0;
	buf->error_code=0;
	buf->flt_flags=0;
	buf->prec.absol=2;
	buf->prec.signi=4;
	return 0;
}
#endif

#ifndef FUNCTION_toopen8
int toopen8(Bufferto8 *buf, const char8_t* fichero){
	if(fichero==NULL) buf->id=ID_NOFILE;
	else{
		buf->id=(uintptr_t)(void*)fopen(fichero,"wt");
		ifunlike(buf->id==ID_NOFILE) return 1;
	}
	int nret=to_setup_buffer(buf,BufSize,to_EXTRASIZE,sizeof(char8_t));
	buf->fillchar=' ';
	buf->maschar='\0';
	return nret;
}
#endif

#if !defined(FUNCTION_toopen_mixed) || !defined(FUNCTION_toopen16)
int try_open16(const char16_t* fichero, BuffertoGeneric *buf){
	if(fichero==NULL){
		buf->id=ID_NOFILE;
		return 0;
	}

	char8_t* filename_c;
	int k=stru8___str16(NULL,fichero);
	ifunlike(k==-1){
		buf->id=ID_NOFILE;
		return ATFILEO_OPEN_BADPATH;
	}
	filename_c=(char8_t*)malloc((uint)k*usizeof(char8_t));
	ifunlike(filename_c==NULL){
		buf->id=ID_NOFILE;
		return AT_NOMEM;
	}
	stru8___str16(filename_c,fichero);

	buf->id=(uintptr_t)(void*)fopen(filename_c,"wt");
	free(filename_c);
	ifunlike(buf->id==ID_NOFILE) return ATFILEO_OPEN_UNKNOWN;

	return 0;
}
#endif

#ifndef FUNCTION_toopen_mixed
int toopen_mixed(Bufferto8 *buf, const char16_t* fichero){
	int nret=try_open16(fichero,(BuffertoGeneric*)buf);
	ifunlike(nret!=0) return nret;
	nret=to_setup_buffer((BuffertoGeneric*)buf,BufSize,to_EXTRASIZE,sizeof(char8_t));
	buf->fillchar=' ';
	buf->maschar='\0';
	return nret;
}
#endif

#ifndef FUNCTION_toopen16
int toopen16(Bufferto16 *buf, const char16_t* fichero){
	int nret=try_open16(fichero,(BuffertoGeneric*)buf);
	ifunlike(nret!=0) return nret;
	nret=to_setup_buffer((BuffertoGeneric*)buf,BufSize,to_EXTRASIZE,sizeof(char16_t));
	buf->fillchar=u' ';
	buf->maschar=u'\0';
	return nret;
}
#endif

#ifndef FUNCTION_SetupFormatter
int SetupFormatter(ATFormatter *buf){
	buf->id=ID_NOFILE;
	int nret=to_setup_buffer(buf,0400,to_EXTRASIZE,sizeof(char8_t));
	buf->fillchar=u' ';
	buf->maschar=u'\0';
	return nret;
}
#endif

#ifndef FUNCTION_bo_immediateclose /*close the file. Discard contents of buffer*/
void bo_immediateclose(Buffer_bo *buf){
	if(buf->id!=ID_NOFILE) fclose((FILE*)buf->id);
	iflike(buf->base!=NULL){free(buf->base); buf->base=NULL;}
	buf->id=ID_NOFILE;
}
#endif

//0: successful; 11: other error; 12: not enough space left
#ifndef FUNCTION_bo_internalflush
void bo_internalflush(Buffer_bo *buf){
	ifunlike(buf->error_code) return;
	ifunlike(buf->id==ID_NOFILE){buf->error_code=ATFILEO_ERROR_NOSPACE; return;}
	size_t i=fwrite_uints(buf->id,buf->base,(pdif)(buf->ptr-buf->base));
	iflike(i==(size_t)(buf->ptr-buf->base)) return;
	buf->error_code=ATFILEO_ERROR_OTHER;
}
#endif

#ifndef FUNCTION_boclose /*Empty the buffer and close the file*/
void boclose(Buffer_bo *buf){
	if(buf->id!=ID_NOFILE) bo_internalflush(buf);
	bo_immediateclose(buf);
}
#endif

#ifndef FUNCTION_to_immediateclose /*close the file. Discard contents of buffer*/
void to_immediateclose(BuffertoGeneric *buf){
	if(buf->id!=ID_NOFILE) fclose((FILE*)buf->id);
	iflike(buf->base!=NULL){free(buf->base); buf->base=NULL;}
	buf->id=ID_NOFILE;
}
#endif

//0: successful; see error codes in ATfileoutput.h
#ifndef FUNCTION_to_internalflush
void to_internalflush(BuffertoGeneric *buf){
	ifunlike(buf->error_code) return;
	ifunlike(buf->id==ID_NOFILE){buf->error_code=ATFILEO_ERROR_NOSPACE; return;}
	size_t i=fwrite(buf->base,usizeof(char8_t),buf->ptr-buf->base,(FILE*)buf->id);
	iflike(i==(size_t)(buf->ptr-buf->base)) return;
	buf->error_code=ATFILEO_ERROR_OTHER;
}
#endif

#ifndef FUNCTION_toclose /*Empty the buffer and close the file*/
void toclose_generic(BuffertoGeneric *buf){
	if(buf->id!=ID_NOFILE) to_internalflush(buf);
	to_immediateclose(buf);
}
#endif

#undef FUNCTION_bo_setup_buffer
#undef FUNCTION_boopen
#undef FUNCTION_boopen_c
#undef FUNCTION_to_setup_buffer
#undef FUNCTION_toopen8
#undef FUNCTION_toopen_mixed
#undef FUNCTION_toopen16
#undef FUNCTION_bo_immediateclose
#undef FUNCTION_bo_internalflush
#undef FUNCTION_boclose
#undef FUNCTION_to_immediateclose
#undef FUNCTION_to_internalflush
#undef FUNCTION_toclose
#undef FUNCTION_toflush

#else
#undef IGNORE_ALL
#endif

#if FILE8BITS_ARE_UTF8
int (boopen_utf8)(Buffer_bo *buf, const char8_t* fichero, u8int endianness){
	return boopen8(buf,fichero,endianness);
}
#else
int boopen_utf8(Buffer_bo *buf, const char8_t* fichero, u8int endianness){
	int nret;
	uint k;
	char16_t *fichero16;

	k=strlen8(fichero)+1;
	fichero16=(char16_t*)malloc(k*usizeof(char16_t));
	ifunlike(fichero16==NULL) return AT_NOMEM;
	str16___stru8(fichero16,fichero);
	nret=boopen16(buf,fichero16,endianness);
	free(fichero16);
	return nret;
}
#endif

#if FILE8BITS_ARE_UTF8
int (toopen_utf8)(Bufferto8 *buf, const char8_t* fichero){
	return toopen8(buf,fichero);
}
#else
int toopen_utf8(Bufferto8 *buf, const char8_t* fichero){
	int nret;
	uint k;
	char16_t *fichero16;

	k=strlen8(fichero)+1;
	fichero16=(char16_t*)malloc(k*usizeof(char16_t));
	ifunlike(fichero16==NULL) return AT_NOMEM;
	str16___stru8(fichero16,fichero);
	nret=toopen_mixed(buf,fichero16);
	free(fichero16);
	return nret;
}
#endif
