#include "../include/ATmemstr.h"
#include "../include/ATstring.h"
#include "../include/ATiflike.h"

#ifdef SYSTEM  //else no issue warning porque ya se habrá avisado en el .h
#include mergestring(paths_,SYSTEM.c)
#endif

#ifndef IGNORE_ALL
#ifndef FUNCTION_path_go_back16
void path_go_back16(char16_t *s){
	char16_t *ptr;
	bint b;

	if(*s=='\0' || Path_isthis(s)){Path_back(s); return;}
	b=path_empty_is_valid;
	if(Path_isabs(s)){
		path_skipabs(s);
		if(*s=='\0') return;
		b=1;
	}
	ptr=s+strlen16(s)-1;
	if(ispath_sep(ptr)) path_unsep(ptr,s);
	if(ptr!=s){
		while(!ispath_sep(ptr) && ptr--!=s);
		ptr++;
	}
	if(!b && ptr==s) path_this(ptr);
	*ptr='\0';
}
#endif

#ifndef FUNCTION_path_clean8
void path_clean8(char8_t *path){
	char8_t *first, *s2, *s1;
	first=path;
	if(Path_isabs(path)) path_skipabs(first);
	else if(ispath_sep(path)) path_skipsep(first);
	while(path_isback(first)) path_skipback(first);
	s1=s2=first;

	while(*s2!='\0'){
		if(!path_isexrel(s2)){
			do *s1++=*s2++; while(*s2!='\0' && !ispath_sep(s2));
			if(*s2!='\0'){
				path_skipsep(s2);
				path_sep(s1);
			}
		}else{
			while(path_isthis(s2)) path_skipthis(s2);
			if(path_isback(s2)){
				path_skipback(s2);
				if(s1==first){
					path_back(s1);
					first+=STRLEN_pathback;
				}else{
					s1--; path_unsep_unsafe(s1);
					while(!ispath_sep(s1) && s1!=first) s1--;
					if(s1!=first) s1++;
				}
			}
		}
	}
	*s1='\0';
}
#endif

#ifndef FUNCTION_path_clean16
void path_clean16(char16_t *path){
	char16_t *first, *s2, *s1;
	first=path;
	if(Path_isabs(path)) path_skipabs(first);
	else if(ispath_sep(path)) path_skipsep(first);
	while(path_isback(first)) path_skipback(first);
	s1=s2=first;

	while(*s2!='\0'){
		if(!path_isexrel(s2)){
			do *s1++=*s2++; while(*s2!='\0' && !ispath_sep(s2));
			if(*s2!='\0'){
				path_skipsep(s2);
				path_sep(s1);
			}
		}else{
			while(path_isthis(s2)) path_skipthis(s2);
			if(path_isback(s2)){
				path_skipback(s2);
				if(s1==first){
					path_back(s1);
					first+=STRLEN_pathback;
				}else{
					s1--; path_unsep_unsafe(s1);
					while(!ispath_sep(s1) && s1!=first) s1--;
					if(s1!=first) s1++;
				}
			}
		}
	}
	*s1='\0';
}
#endif

#ifndef FUNCTION_makepath8
void makepath8(char8_t* Path, u16int buf_size, const char8_t* curr_path, const char8_t* ruta){ //curr_path cannot be NULL
	char8_t *end;
	Path[buf_size-1]='\0';
	if(ruta==NULL || *ruta=='\0'){strcpy8(Path,curr_path); return;}
	if(*curr_path=='\0' || Path_isabs(ruta)){strncpy8(Path,ruta,buf_size); return;}

	if(ispath_sep(ruta)) path_skipsep(ruta);
	end=strpcpy8(Path,curr_path);
	if(!ispath_sep(end-1)) path_sep(end);

	strncpy8(end,ruta,buf_size-(pdif)(end-Path));
	if(Path[buf_size-1]!='\0') return;
	path_clean8(Path);
}
#endif

#ifndef FUNCTION_makepath16
void makepath16(char16_t* Path, u16int buf_size, const char16_t* curr_path, const char16_t* ruta){ //curr_path cannot be NULL
	char16_t *end;
	Path[buf_size-1]='\0';
	if(ruta==NULL || *ruta=='\0'){strcpy16(Path,curr_path); return;}
	if(*curr_path=='\0' || Path_isabs(ruta)){strncpy16(Path,ruta,buf_size); return;}

	if(ispath_sep(ruta)) path_skipsep(ruta);
	end=strpcpy16(Path,curr_path);
	if(!ispath_sep(end-1)) path_sep(end);

	strncpy16(end,ruta,buf_size-(pdif)(end-Path));
	if(Path[buf_size-1]!='\0') return;
	path_clean16(Path);
}
#endif

#ifndef FUNCTION_make_from_currentpath16
void make_from_currentpath16(char16_t* Path, u16int buf_size, const char16_t* curr_path, const char16_t* ruta, uint* pth_length){
	makepath16(Path,buf_size-1,curr_path,ruta); //for the possible dir. sep. to be appended
	ifunlike(Path[buf_size-2]!='\0'){
		Path[buf_size-2]='\0';
		path_remove_file16(Path);
	}
	*pth_length=(pdif)strlen16(Path);
	if(!ispath_sep(Path+(*pth_length-1))){
		Path_sep(Path+*pth_length);
		(*pth_length)+=STRLEN_pathsep;
	}
}
#endif

#ifndef FUNCTION_pathskip_common16
void pathskip_common16(const char16_t* path1, const char16_t* path2, const char16_t* *ptr1, const char16_t* *ptr2){
	const char16_t *ps1, *ps2;

	if(Path_isabs(path1)){
		if(!Path_isabs(path2)){*ptr1=path1; *ptr2=path2; return;}
		ps1=path1, ps2=path2;
		path_skipabs(ps1);
		path_skipabs(ps2);
		while(path1!=ps1 && path2!=ps2){
			if(*path1!=*path2) break;
			path1++, path2++;
		}
		if(path1!=ps1){*ptr1=path1; *ptr2=path2; return;}
	}else{
		if(Path_isabs(path2)){*ptr1=path1; *ptr2=path2; return;}
		while(path_isthis(path1)) path_skipthis(path1);
		while(path_isthis(path2)) path_skipthis(path2);
	}

	for(ps1=path1,ps2=path2; *ps1!='\0' && *ps2!='\0';ps1++,ps2++){
		if(*ps1!=*ps2) break;
	}
	if(ispath_sep(ps1) && *ps2=='\0') path_skipsep(ps1);
	else if(*ps1=='\0' && ispath_sep(ps2)) path_skipsep(ps2);
	else{
		while(ps1!=path1){ ps1--, ps2--;
			if(ispath_sep(ps1)) break;
		}
		if(ispath_sep(ps1)) ps1++, ps2++;
	}
	*ptr1=ps1;
	*ptr2=ps2;
}
#endif

#ifndef FUNCTION_relative_path16
void relative_path16(char16_t* relpath, u16int buf_size, const char16_t* pathref, const char16_t* filename){
	const char16_t *pref, *pfile;
	s16int k;

	if(!Path_isabs(pathref) || !Path_isabs(filename)){
		char16_t* prel=relpath-1;
		for(u16int i=buf_size; (*prel=*filename) && --i!=0; prel++,filename++);
		if(*prel!='\0') *relpath='\0';
		return;
	}
	pathskip_common16(pathref,filename,&pref,&pfile);
	k=0;
	if(*pref!='\0'){
		const char16_t *ptr;
		for(ptr=pref; *ptr!='\0';){
			if(path_isthis(ptr)) path_skipthis(ptr);
			else if(path_isback(ptr)){path_skipback(ptr); k--;}
			else if(ispath_sep(ptr)){path_skipsep(ptr); k++;}
			else ptr++;
		}
		ptr--; if(ispath_sep(ptr)) k--;
		if(k<0) k=0;  //The result will be wrong
	}

	if(*pfile=='\0'){
		if(k==0){Path_this(relpath); return;}
		iflike(STRLEN_pathback*(u16int)k<buf_size){
			while(k--) path_back(relpath);
		}
		*relpath='\0';
		return;
	}

	u16int l;
	{const char16_t *ptr=pfile; do ptr++; while(*ptr!='\0'); l=(u16int)(ptr-pfile);}
	if(k==0){
		ifunlike(STRLEN_paththis+l>=buf_size) l=0;
		else path_this(relpath);
	}else{
		ifunlike(STRLEN_pathback*k+l>=buf_size) l=0;
		else{
			while(k--) path_back(relpath);
		}
	}
	if(l!=0){while(*pfile) *relpath++=*pfile++;}
	*relpath='\0';
}
#endif

#ifndef FUNCTION_remove_filename
int remove_filename16(char16_t *directory, u16int buf_size, const char16_t* filename, char16_t **ptrfin){
	const char16_t *pfinal0;
	char16_t *pfinal;
	int bad;

	bad=0;
	path_get_filename16(filename,pfinal0);
	if(pfinal0==filename){
		pfinal=directory;
		path_this(pfinal);
	}else{
		ifunlike((pdif)(pfinal0-filename)>buf_size){
			bad=1;
			pfinal0=filename+buf_size;
		}
		const char16_t *p2=filename;
		pfinal=directory;
		do *pfinal++=*p2++; while(p2!=pfinal0);

		ifunlike(bad){
			do pfinal--; while(!ispath_sep(pfinal) && pfinal!=directory);
			if(ispath_sep(pfinal)) pfinal++;
			else if(pfinal==filename){
				pfinal=directory;
				path_this(pfinal);
			}
		}
	}
	*pfinal='\0';

	if(ptrfin!=NULL) *ptrfin=pfinal;
	return bad;
}
#endif
#endif

#undef FUNCTION_remove_filename
#undef FUNCTION_relative_path16
#undef FUNCTION_pathskip_common16
#undef FUNCTION_make_from_currentpath16
#undef FUNCTION_makepath16
#undef FUNCTION_makepath8
#undef FUNCTION_path_clean16
#undef FUNCTION_path_clean8
#undef FUNCTION_path_go_back16
#undef IGNORE_ALL
