﻿#ifndef IGNORE_ALL

char16_t* strbuild16(char16_t* s1, const char16_t* t0, ...){
	va_list ap;
	va_start(ap, t0);
	while(t0!=NULL){
		s1=strpcpy16(s1,t0);
		t0=va_arg(ap,const char16_t*);
	}
	va_end(ap);
	return s1;
}

char16_t* strbuild_mixed(char16_t* s1, int tipo0, ...){
	va_list ap;
	va_start(ap, tipo0);
	while(tipo0!=0 && tipo0!='0'){	//'0' porque es un error común escribirlo en lugar de '\0'
		if(tipo0=='w'){
			const char16_t *ws=va_arg(ap,const char16_t*);
			s1=strpcpy16(s1,ws);
		}else{  /* 'c' */
			const char8_t *cs=va_arg(ap,const char8_t*);
			while(*cs) *s1++=*cs++;
			*s1=u'\0';
		}
		tipo0=va_arg(ap,int);
	}
	va_end(ap);
	return s1;
}

#else
#undef IGNORE_ALL
#endif
