#ifndef TOWRITE_C_INCLUDED
	//#includeif mergestring(to_write_,COMPILER.c)
	#if COMPILER_ID==MSC_ID
	#include mergestring(to_write_,COMPILER.c)
	#endif

	#define TOWRITE_C_INCLUDED
	#ifndef IGNORE_ALL
	#if !defined(FUNCTION_do_towrite_absolute_d) || !defined(FUNCTION_do_towrite_relative_d)
	#include <math.h>
	#endif

	//no voy a permitir una precisión mayor que 18
	//ni menor de -6.
	//10^9 se puede pasar a entero, 10^10 no
	static const double pot10pos[10]={1.0,10.0,100.0,1000.0,10000.0,100000.0,1000000.0,10000000.0, 1.0E8, 1.0E9};
	static const double pot10neg[10]={1.0,0.1,.01,.001,.0001,.00001,.000001,.0000001, 1.0E-8, 1.0E-9};
	static const uint pot10int[10]={1,10,100,1000,10000,100000,1000000,10000000, 100000000, 1000000000};
	static const double pot10half[7]={0.5,5,50,500,5000,50000,500000};

	#ifndef FUNCTION_log10n_d
		static inline s8int log10n_d(double x){
			ifunlike(x==0) return -127;
			ifunlike(x<0) x=-x;

			s8int log=0;
			while(x<1) x*=10,log--;
			for(double y=10.0; x>=y; y*=10,log++);
			return log;
		}
	#endif
	#ifndef FUNCTION_log10n
		static inline u8int log10n(uint n){
			u8int log=0;
			for(uint y=10; n>=y; y*=10,log++);
			return log;
		}
	#endif

	#define BUFFER8
	#define CHARWD 8
	#define TYPE char8_t
	#define TYPEBUF Bufferto8
	#define TOWRITE(x) merge(towrite8,x)
	#include "to_write_C.c"		//__FILE__  fails if the compiler was started from another diectory
	#undef CHARWD
	#undef TYPE
	#undef TYPEBUF
	#undef TOWRITE

	#undef BUFFER8
	#define CHARWD 16
	#define TYPE char16_t
	#define TYPEBUF Bufferto16
	#define TOWRITE(x) merge(towrite16,x)
	#define FUNCTION_toput_utf8char
	#define FUNCTION_towrite_string16_charred
	#define FUNCTION_towrite_string16_utf8
	#define FUNCTION_towrite_string8_utf8
	#include "to_write_C.c"
	#undef CHARWD
	#undef TYPE
	#undef TYPEBUF
	#undef TOWRITE

	#undef FUNCTION_log10n_d
	#undef FUNCTION_towrite_string
	#undef FUNCTION_towrite_string_s
	#undef FUNCTION_towrite_string_t
	#undef FUNCTION_towrite_string_st
	#undef FUNCTION_towrite_string_n
	#undef FUNCTION_towrite_string_b
	#undef FUNCTION_towrite_string_b0
	#undef FUNCTION_towrite_left_string
	#undef FUNCTION_towrite_aligned_string
	#undef FUNCTION_toput_utf8char
	#undef FUNCTION_towrite_string16_charred
	#undef FUNCTION_towrite_string16_utf8
	#undef FUNCTION_towrite_string8_utf8
	#undef FUNCTION_do_towrite_uint
	#undef FUNCTION_towrite_uint
	#undef FUNCTION_towrite_left_uint
	#undef FUNCTION_towrite_aligned_uint
	#undef FUNCTION_do_towrite_ssnt
	#undef FUNCTION_towrite_ssint
	#undef FUNCTION_towrite_left_ssint
	#undef FUNCTION_towrite_aligned_ssint
	#undef FUNCTION_do_towrite_hex
	#undef FUNCTION_towrite_hex
	#undef FUNCTION_towrite_left_hex
	#undef FUNCTION_towrite_aligned_hex
	#undef FUNCTION_do_towrite_absolute_d
	#undef FUNCTION_do_towrite_relative_d
	#undef FUNCTION_towrite_double
	#undef FUNCTION_towrite_left_double
	#undef FUNCTION_towrite_aligned_double
	#undef FUNCTION_towrite_float
	#undef FUNCTION_towrite_left_float
	#undef FUNCTION_towrite_aligned_float
	#undef FUNCTION_towrite
	#undef FUNCTION_towritef
	#undef FUNCTION_towrite_many_strings

	#else
	#undef IGNORE_ALL
	#endif

#else	/*TOWRITE_C_INCLUDED*/

//El espacio que empieza en buf->top+256 lo utilizan la funciones que escriben material alineado,
//buf->backPtr hacia atrás, para enteros. Puden ser necesarios ambos a la vez para floats alineados.
//las funciones do_... que no escriben alineado no pueden usar top, porque es posible que se les llame
//con el puntero buf->ptr movido a ese espacio.

#ifndef FUNCTION_toput_utf8char
inline void toput_utf8char(Bufferto8 *buf,const char16_t s){
	if(!(s&~0x7FU)){*buf->ptr++=(char8_t)s; return;}
	if(s<0x800){
		*buf->ptr++=(char8_t)(0xC0 | (s>>6));
	}else{
		//if(s<0x10000){
			*buf->ptr++=(char8_t)(0xE0 | (s>>12));
		/*}else{
			*buf->ptr++=(char8_t)(0xF0 | (s>>18));
			*buf->ptr++=(char8_t)(0x80 | ((s>>12)&0x3F));
		}*/
		*buf->ptr++=(char8_t)(0x80 | ((s>>6)&0x3F));
	}
	*buf->ptr++=(char8_t)(0x80 | (s&0x3F));
	return;
}
#endif

#ifndef FUNCTION_towrite_string
inline void TOWRITE(_string)(TYPEBUF *buf,const TYPE *s){
	while(*s!='\0'){
		to_checkflush(buf);
		while(buf->ptr!=buf->top && *s!='\0') *buf->ptr++=*s++;
	}
}
void TOWRITE(_stringl)(TYPEBUF *buf,const TYPE *s, TYPE nl){
	while(*s!='\0'){
		to_checkflush(buf);
		while(buf->ptr!=buf->top && *s!='\0') *buf->ptr++=*s++;
	}
	to_checkflush(buf);
	do_toput_char(buf,nl);
}
#endif

#ifndef FUNCTION_towrite_string_s
void TOWRITE(_string_s)(TYPEBUF *buf,const TYPE *s){
	while(*s!=' '){
		to_checkflush(buf);
		while(buf->ptr!=buf->top && *s!=' ') *buf->ptr++=*s++;
	}
}
#endif

#ifndef FUNCTION_towrite_string_s0
void TOWRITE(_string_s0)(TYPEBUF *buf,const TYPE *s){
	while(*s!=' ' && *s!='\0'){
		to_checkflush(buf);
		while(buf->ptr!=buf->top && *s!=' ' && *s!='\0') *buf->ptr++=*s++;
	}
}
#endif

#ifndef FUNCTION_towrite_string_t
void TOWRITE(_string_t)(TYPEBUF *buf,const TYPE *s){
	while(*s!='\t'){
		to_checkflush(buf);
		while(buf->ptr!=buf->top && *s!='\t') *buf->ptr++=*s++;
	}
}
#endif

#ifndef FUNCTION_towrite_string_st
void TOWRITE(_string_st)(TYPEBUF *buf,const TYPE *s){
	while(isnot_st(*s)){
		to_checkflush(buf);
		while(buf->ptr!=buf->top && isnot_st(*s)) *buf->ptr++=*s++;
	}
}
#endif

#ifndef FUNCTION_towrite_string_n
void TOWRITE(_string_n)(TYPEBUF *buf,const TYPE *s){
	while(*s!='\n'){
		to_checkflush(buf);
		while(buf->ptr!=buf->top && *s!='\n') *buf->ptr++=*s++;
	}
}
#endif

#ifndef FUNCTION_towrite_string_n0
void TOWRITE(_string_n0)(TYPEBUF *buf,const TYPE *s){
	while(*s!='\n' && *s!='\0'){
		to_checkflush(buf);
		while(buf->ptr!=buf->top && *s!='\n' && *s!='\0') *buf->ptr++=*s++;
	}
}
#endif

#ifndef FUNCTION_towrite_string_b
void TOWRITE(_string_b)(TYPEBUF *buf,const TYPE *s){
	while(isnot_stn(*s)){
		to_checkflush(buf);
		while(buf->ptr!=buf->top && isnot_stn(*s)) *buf->ptr++=*s++;
	}
}
#endif

#ifndef FUNCTION_towrite_string_b0
void TOWRITE(_string_b0)(TYPEBUF *buf,const TYPE *s){
	while(isnot_stn0(*s)){
		to_checkflush(buf);
		while(buf->ptr!=buf->top && isnot_stn0(*s)) *buf->ptr++=*s++;
	}
}
#endif

#ifndef FUNCTION_towrite_left_string
void TOWRITE(_left_string)(TYPEBUF *buf,const TYPE* s, u8int width){
	while(*s!='\0' && width--) *buf->ptr++=*s++;
	if(*s=='\0'){	//width es correcto aquí
		while(width--) *buf->ptr++=buf->fillchar;
		to_checkflush(buf);
	}else{
		//to_checkflush(buf);	//en towrite_string
		TOWRITE(_string)(buf,s);
	}
}
#endif

#ifndef FUNCTION_towrite_aligned_string
void TOWRITE(_aligned_string)(TYPEBUF *buf,const TYPE* s,u8int width){
	TYPE *ptr=buf->top+256;
	while(*s!='\0' && width--) *ptr++=*s++;
	if(*s=='\0'){
		*ptr='\0';
		ptr=buf->top+256;
		while(width--) *buf->ptr++=buf->fillchar;
		while(*ptr!='\0') *buf->ptr++=*ptr++;
		to_checkflush(buf);
		return;
	}else{
		s-=ptr-(buf->top+256);
		TOWRITE(_string)(buf,s);
	}
}
#endif

#ifndef FUNCTION_towrite_string16_charred
/*inline*/ void towrite_string16_charred(Bufferto8 *buf,const char16_t *s){
	while(*s!='\0'){
		to_checkflush(buf);
		while(buf->ptr!=buf->top && *s!='\0') *buf->ptr++=(char8_t)(*s++);
	}
}
#endif

#ifndef FUNCTION_towrite_string16_utf8
/*inline*/ void towrite_string16_utf8(Bufferto8 *buf,const char16_t *s){
	while(*s!='\0'){
		to_checkflush(buf);
		while(buf->ptr<buf->top && *s!='\0'){toput_utf8char(buf,*s); s++;}
	}
}
#endif

#ifndef FUNCTION_towrite_string8_utf8
/*inline*/ void towrite_string8_utf8(Bufferto8 *buf,const char8_t *s){
	while(*s!='\0'){
		to_checkflush(buf);
		while(buf->ptr<buf->top && *s!='\0'){
			char8_t c;
			if((c=*s++)<0x80) *buf->ptr++=c;
			else{*buf->ptr++=(0xC0 | (c>>6));
				*buf->ptr++=(0x80 | (c&0x3F));}
		}
	}
}
#endif

#ifndef FUNCTION_do_towrite_uint
void merge(do_,TOWRITE(_uint))(TYPEBUF *buf,uint x){
	if(x<10){
		do_toput_char(buf,(char8_t)(x+'0'));
	}else{
		TYPE *ptr=buf->backPtr;
		while(x>=10){
			uint y=x/10;
			*ptr--=(TYPE)(x-10*y+'0');
			x=y;
		}
		*ptr=(TYPE)(x+'0');
		while(*ptr!=0) *buf->ptr++=*ptr++;
	}
}
#else
void merge(do_,TOWRITE(_uint))(TYPEBUF *buf,uint x);
#endif

#ifndef FUNCTION_do_towrite_ssint
static inline void merge(do_,TOWRITE(_ssint))(TYPEBUF *buf,ssint x){
	if(x<0){do_toput_char(buf,'-'); x=-x;}
	merge(do_,TOWRITE(_uint))(buf,x);
}
#else
void merge(do_,TOWRITE(_ssint))(TYPEBUF *buf,ssnt x);
#endif

#ifndef FUNCTION_do_towrite_hex
void merge(do_,TOWRITE(_hex))(TYPEBUF *buf,uint x){
	TYPE *ptr=buf->backPtr+1;
	do{ ptr--;
		uint y=x&0xF;	x>>=4;
		if(y<10) y+='0';		else y+='A'-10;
		*ptr=(TYPE)y;
	}while(x);
	while(*ptr!=0) *buf->ptr++=*ptr++;
}
#else
void merge(do_,TOWRITE(_hex))(TYPEBUF *buf,uint x);
#endif

#ifndef FUNCTION_towrite_uint
void TOWRITE(_uint)(TYPEBUF *buf,uint x){
	merge(do_,TOWRITE(_uint))(buf,x);
	to_checkflush(buf);
}
#endif

#ifndef FUNCTION_towrite_left_uint
void TOWRITE(_left_uint)(TYPEBUF *buf,uint x, u8int width){
	TYPE *ptr=buf->ptr+width;
	merge(do_,TOWRITE(_uint))(buf,x);
	while(buf->ptr<ptr) *buf->ptr++=buf->fillchar;
	to_checkflush(buf);
}
#endif

#ifndef FUNCTION_towrite_hex
void TOWRITE(_hex)(TYPEBUF *buf,uint x){
	merge(do_,TOWRITE(_hex))(buf,x);
	to_checkflush(buf);
}
#endif

#ifndef FUNCTION_towrite_left_hex
void TOWRITE(_left_hex)(TYPEBUF *buf,uint x, u8int width){
	TYPE *ptr=buf->ptr+width;
	merge(do_,TOWRITE(_hex))(buf,x);
	while(buf->ptr<ptr) *buf->ptr++=buf->fillchar;
	to_checkflush(buf);
}
#endif

#ifndef FUNCTION_do_towrite_aligned_uint
void merge(do_,TOWRITE(_aligned_uint))(TYPEBUF *buf,uint x,u8int width){
	TYPE *ptr, *ptr_abajo;
	ptr=buf->backPtr;
	while(x>=10){
		uint y=x/10;
		*ptr--=(TYPE)(x-10*y+'0');
		x=y;
	}
	*ptr--=(TYPE)(x+'0');
	ptr_abajo=buf->backPtr-width;
	while(ptr>ptr_abajo) *ptr--=buf->fillchar;
	ptr++;
	while(*ptr!=0) *buf->ptr++=*ptr++;
}
#else
merge(do_,TOWRITE(_aligned_uint))(TYPEBUF *buf,uint x,u8int width);
#endif

#ifndef FUNCTION_do_towrite_aligned_ssint
void merge(do_,TOWRITE(_aligned_ssint))(TYPEBUF *buf,ssint x,u8int width){
	bint b=0;
	if(x<0) x=-x, b=1;

	TYPE *ptr, *ptr_abajo;
	ptr=buf->backPtr;
	while(x>=10){
		uint y=x/10;
		*ptr--=(TYPE)(x-10*y+'0');
		x=y;
	}
	*ptr--=(TYPE)(x+'0');
	if(b) *ptr--='-';
	ptr_abajo=buf->backPtr-width;
	while(ptr>ptr_abajo) *ptr--=buf->fillchar;
	ptr++;
	while(*ptr!=0) *buf->ptr++=*ptr++;
}
#else
merge(do_,TOWRITE(_aligned_ssint))(TYPEBUF *buf,ssint x,u8int width);
#endif

#ifndef FUNCTION_do_towrite_aligned_hex
void merge(do_,TOWRITE(_aligned_hex))(TYPEBUF *buf,uint x,u8int width){
	TYPE *ptr, *ptr_abajo;
	ptr=buf->backPtr;
	do{
		uint y=x&0xF;	x>>=4;
		if(y<10) y+='0';		else y+='A'-10;
		*ptr--=(TYPE)y;
	}while(x);
	ptr_abajo=buf->backPtr-width;
	while(ptr>ptr_abajo) *ptr--=buf->fillchar;
	ptr++;
	while(*ptr!=0) *buf->ptr++=*ptr++;
}
#else
merge(do_,TOWRITE(_aligned_hex))(TYPEBUF *buf,uint x,u8int width);
#endif

#ifndef FUNCTION_towrite_aligned_uint
void TOWRITE(_aligned_uint)(TYPEBUF *buf,uint x,u8int width){
	merge(do_,TOWRITE(_aligned_uint))(buf,x,width);
	to_checkflush(buf);
}
#endif

#ifndef FUNCTION_towrite_aligned_ssint
void TOWRITE(_aligned_ssint)(TYPEBUF *buf,ssint x,u8int width){
	merge(do_,TOWRITE(_aligned_ssint))(buf,x,width);
	to_checkflush(buf);
}
#endif

#ifndef FUNCTION_towrite_aligned_hex
void TOWRITE(_aligned_hex)(TYPEBUF *buf,uint x,u8int width){
	merge(do_,TOWRITE(_aligned_hex))(buf,x,width);
	to_checkflush(buf);
}
#endif

#ifndef FUNCTION_do_towrite_fixedsize_uint
//write an aligned uint which size we know not to exceed width
//For intenal use in writing floating point numbers.
//width must be >0
void merge(do_,TOWRITE(_fixedsize_uint))(TYPEBUF *buf,uint x,u8int width){
	TYPE *ptr=buf->ptr+(width-1);
	while(x>=10){
		uint y=x/10;
		*ptr--=(TYPE)(x-10*y+'0');
		x=y;
	}
	*ptr=(TYPE)(x+'0');
	while(ptr!=buf->ptr) *--ptr='0';
	buf->ptr+=width;
}
#else
merge(do_,TOWRITE(_fixedsize_uint))(TYPEBUF *buf,uint x,u8int width);
#endif

#ifndef FUNCTION_do_towrite_absolute_d
void merge(do_,TOWRITE(_absolute_d))(TYPEBUF *buf, double fl){
	double fm;
	uint npart;

	if(fl<0){*buf->ptr++='-'; fl=-fl;}
	else if(buf->maschar!='\0') *buf->ptr++=buf->maschar;
	ifunlike(isnan(fl)){
		*buf->ptr++='#';	*buf->ptr++='E';	*buf->ptr++='R';	*buf->ptr++='R';
		return;
	}
	ifunlike(fl>=1.0E18){
		*buf->ptr++='#';	*buf->ptr++='I';	*buf->ptr++='N';	*buf->ptr++='F';
		return;
	}

	ifunlike(buf->prec.absol<0){
		bint bsub;
		if(fl<0.5){*buf->ptr++='0'; return;}
		ifunlike(buf->prec.absol<-6) buf->prec.absol=-6;
		u8int i=(u8int)-buf->prec.absol;

		bsub=isbuf_avoidzero(buf) && _unlikely(fl<pot10half[i]);
		if(bsub) i=log10n((uint)fl);
		npart=(uint)(fl+pot10half[i]);
		if(bsub) i=log10n(npart);	//might have changed, e.g.  0.97 --> 1.02
		else ifunlike(npart<pot10int[i]){*buf->ptr++='0'; return;}
		npart/=pot10int[i];
		merge(do_,TOWRITE(_uint))(buf,npart);
		/*ifunlike(isbuf_scientific(buf) && i>=5){*buf->ptr++='.'; *buf->ptr++='E'; *buf->ptr++='0'+i;}
		else{*/while(i) i--, *buf->ptr++='0';//}
		return;
	}

	if(fl==0){
		fm=1.0;
	}else{
		u8int i=(u8int)buf->prec.absol;
		iflike(i<=9) fm=pot10neg[i];
		else{
			fm=1E-10;
			ifunlike(i>19) i=19;	//The user may ask for more than 19, and they will get printed, but the precision will not be respected.
			fm*=pot10neg[i-10];
		}
		fm*=0.5;
	}
	if(fl<fm){
		*buf->ptr++='0';
		if(!isbuf_limpio(buf) && buf->prec.absol>0){
			cint i=(cint)buf->prec.absol;
			*buf->ptr++='.';
			/*if(buf->prec>3 && isbuf_scientific(buf)){
				*buf->ptr++='E'; *buf->ptr++='-';
				*buf->ptr++=buf->prec/10+'0';
				*buf->ptr++=buf->prec-10*(buf->prec/10)+'0';
			}else{*/
				while(i--) *buf->ptr++='0';
			/*}*/
		}
		return;
	}
	fl+=fm;

	/*if(isbuf_scientific(buf) && fl<0.001){	//hence buf->prec>=4
		u8int saved_prec=buf->prec;
		fl-=fm;
		buf->prec+=log10n_d(fl)+1;	//-=-(...-1)
		do_towrite_relative_d(buf,fl);
		buf->prec=saved_prec;
		return;
	}*/
	ifunlike(fl>=1.0E9){
		npart=(ssint)(fl*1.0E-9);	//prior to (ssint) this will be less than 1E9 +0.5E-9
		merge(do_,TOWRITE(_uint))(buf,npart);
		fl-=(double)npart*1.0E9;
	}
	npart=(ssint)fl;		//fl<= 999999999.999...
	merge(do_,TOWRITE(_uint))(buf,npart);
	if(buf->prec.absol>0){
		TYPE saved_fill;
		u8int i=(u8int)buf->prec.absol;
		fl-=(double)npart;
		*buf->ptr++='.';
		saved_fill=buf->fillchar;
		buf->fillchar='0';
		while(i>9){	//If the user has called checkbuf_prec this can only happen once
			i-=9;
			fl*=1.0E9;
			npart=(ssint)fl;
			merge(do_,TOWRITE(_fixedsize_uint))(buf,npart,9);
			fl-=(double)npart;
		}
		if(i>0){
			fl*=pot10pos[i];
			merge(do_,TOWRITE(_fixedsize_uint))(buf,(ssint)fl,i);
		}
		buf->fillchar=saved_fill;
		if(isbuf_limpio(buf)){
			while(*--buf->ptr=='0');
			if(*buf->ptr!='.') buf->ptr++;
		}
	}
	return;
}
#else
void merge(do_,TOWRITE(_absolute_d))(TYPEBUF *buf, double fl);
#endif

#ifndef FUNCTION_do_towrite_relative_d
void merge(do_,TOWRITE(_relative_d))(TYPEBUF *buf, double fl){
	u8int i;	//effective precision
	s8int d, dif;
	uint fn;

	if(fl<0){*buf->ptr++='-'; fl=-fl;}
	else if(buf->maschar!='\0') *buf->ptr++=buf->maschar;
	if(fl==0){
		*buf->ptr++='0';
		return;
	}
	ifunlike(!isfinite(fl)){
		if(isnan(fl)){*buf->ptr++='#';	*buf->ptr++='E';	*buf->ptr++='R';	*buf->ptr++='R';}
		else{*buf->ptr++='#';	*buf->ptr++='I';	*buf->ptr++='N';	*buf->ptr++='F';}
		return;
	}

	i=buf->prec.signi;
	ifunlike(i>9) i=9;	if(i==0) i=1;
	d=log10n_d(fl);
	dif=d-i+1;		//log10n de la última cifra. Si <0 es el nº de decimales
	{double fpart;
	s8int j=dif;
	fpart=1;
	if(j<0){
		while(j<-9){fpart*=1.0E10; j+=10;}
		fpart*=pot10pos[-j];
	}else{
		while(j>9){fpart*=1.0E-10; j-=10;}
		fpart*=pot10neg[j];
	}
	fn=(ssint)(fl*fpart+0.5);	//fn son las i cifras significativas. fl*fpart<10^i
	ifunlike(fn==pot10int[i]){fn=pot10int[i-1]; d++; dif++;}
	}

	if((d<-3 || dif>3) && isbuf_scientific(buf)){
		TYPE *ppio=buf->ptr++;
		merge(do_,TOWRITE(_uint))(buf,fn);
		*ppio=*(ppio+1), ppio++;
		*ppio='.';
		*buf->ptr++='E';
		if(d<0){*buf->ptr++='-';	 d=-d;}
		else *buf->ptr++='+';
		*buf->ptr++=(TYPE)(d/10+'0');
		*buf->ptr++=(TYPE)(d-10*(d/10)+'0');
		return;
	}

	if(d>=0){
		merge(do_,TOWRITE(_uint))(buf,fn);
		if(dif>=0){
			while(dif){dif--; *buf->ptr++='0';}
		}else{
			TYPE *ptr=buf->ptr++;
			do{dif++; *ptr=*(ptr-1), ptr--;}while(dif<0);
			*ptr='.';
			dif=-1;		//for limpiar below
		}
	}else{	//dif<0
		d=-d-1;	//núm. de ceros tras la coma
		*buf->ptr++='0'; *buf->ptr++='.';
		for(;d>0;d--) *buf->ptr++='0';
		merge(do_,TOWRITE(_uint))(buf,fn);
	}
	if(dif<0 && isbuf_limpio(buf)){
		while(*--buf->ptr=='0');
		if(*buf->ptr!='.') buf->ptr++;
	}
	return;
}
#else
void merge(do_,TOWRITE(_relative_d))(TYPEBUF *buf, double fl);
#endif

#define do_towrite8_double(buf,fl) \
	do{if(isbuf_absolute(buf)) do_towrite8_absolute_d(buf,fl);\
	else do_towrite8_relative_d(buf,fl);} while(0)

#define do_towrite16_double(buf,fl) \
	do{if(isbuf_absolute(buf)) do_towrite16_absolute_d(buf,fl);\
	else do_towrite16_relative_d(buf,fl);} while(0)

#ifndef FUNCTION_towrite_double
void TOWRITE(_double)(TYPEBUF *buf, double fl){
	merge(do_,TOWRITE(_double))(buf,fl);
	to_checkflush(buf);
}
#endif
#ifndef FUNCTION_towrite_left_double
void TOWRITE(_left_double)(TYPEBUF *buf, double fl, u8int width){
	TYPE *ptr=buf->ptr+width;
	merge(do_,TOWRITE(_double))(buf,fl);
	while(buf->ptr<ptr) *buf->ptr++=buf->fillchar;
	to_checkflush(buf);
}
#endif

#ifndef FUNCTION_towrite_aligned_double
void TOWRITE(_aligned_double)(TYPEBUF *buf, double fl, u8int width){
	u8int wocupa;
	TYPE *ptr_saved=buf->ptr;
	buf->ptr=buf->top+256;
	merge(do_,TOWRITE(_double))(buf,fl);
	wocupa=(u8int)(buf->ptr-(buf->top+256));
	if(wocupa<width){
		for(width-=wocupa;width--;*ptr_saved++=buf->fillchar);
	}
	buf->ptr=buf->top+256;
	while(wocupa--) *ptr_saved++=*buf->ptr++;
	buf->ptr=ptr_saved;
	to_checkflush(buf);
}
#endif

#ifndef FUNCTION_towrite_many_strings
void TOWRITE(_many_strings)(TYPEBUF *buf, const TYPE *s1,...){
	va_list ap;
	va_start(ap, s1);
	while(s1!=NULL){
		TOWRITE(_string)(buf,s1);
		s1=va_arg(ap,const TYPE*);
	}
	va_end(ap);
}
#endif

//tipos: 'c', 's', 'S', 'u', 'x', 'i', 'f'
#ifndef FUNCTION_towrite
void TOWRITE(TOWRITE_C_INCLUDED)(TYPEBUF *buf, int tipo0,...){
	va_list ap;
	va_start(ap, tipo0);
	while(tipo0!=0){
		if(tipo0=='s' || tipo0=='S'){
			const TYPE *s=va_arg(ap,const TYPE*);
			if(tipo0=='s') TOWRITE(_string)(buf,s);
			else TOWRITE(_string_b0)(buf,s);
		}
	#ifdef BUFFER8
		else if(tipo0=='w'){
			const char16_t *s=va_arg(ap,const char16_t*); towrite8_string16_utf8(buf,s);
		}
	#endif
		else{
			switch(tipo0){
			case 'c': {TYPE c=(TYPE)va_arg(ap,int); do_toput_char(buf,c);} break;
			case 'u': {uint n=(uint)va_arg(ap,unsigned int); merge(do_,TOWRITE(_uint))(buf,n);} break;
			case 'x': {uint n=(uint)va_arg(ap,unsigned int); merge(do_,TOWRITE(_hex))(buf,n);} break;
			case 'i': {ssint n=(ssint)va_arg(ap,int); merge(do_,TOWRITE(_ssint))(buf,n);} break;
			case 'f': {double f=va_arg(ap,double); merge(do_,TOWRITE(_double))(buf,f);} break;
			default: do_toput_char(buf,(TYPE)tipo0);	//Any other character prints itself
			}
			to_checkflush(buf);
		}
		tipo0=va_arg(ap,int);
	}
	va_end(ap);
}
#endif

//tipos: 'c', 's', 'S<x>', 'u', 'x', 'i', 'f'
#ifndef FUNCTION_towritef
void merge(towritef,CHARWD)(TYPEBUF *buf, const TYPE* str,...){
	va_list ap;
	va_start(ap, str);
	const TYPE *ps=str;
	while(*ps!='\0'){
		if(*ps!='%'){
			do{to_checkflush(buf);
				while(buf->ptr!=buf->top && *ps!='\0' && *ps!='%') *buf->ptr++=*ps++;
			}while(*ps!='\0' && *ps!='%');
		}else{
			ps++;
			TYPE t=*ps++;
			if(t=='s'){
				const TYPE *s=va_arg(ap,const TYPE*);
				TOWRITE(_string)(buf,s);
			}else if(t=='S'){
				t=*ps;
				iflike(*ps!='\0') ps++;
				const TYPE *s=va_arg(ap,const TYPE*);
				switch(t){
				case 's': TOWRITE(_string_s)(buf,s); break;
				case 'S': TOWRITE(_string_s0)(buf,s); break;
				case 't': TOWRITE(_string_t)(buf,s); break;
				case 'T': TOWRITE(_string_st)(buf,s); break;
				case 'n': TOWRITE(_string_n)(buf,s); break;
				case 'N': TOWRITE(_string_n0)(buf,s); break;
				case 'b': TOWRITE(_string_b)(buf,s); break;
				case 'B': default: TOWRITE(_string_b0)(buf,s); break;
				}
			}
	#ifdef BUFFER8
			else if(t=='w'){
				const char16_t *s=va_arg(ap,const char16_t*); towrite8_string16_utf8(buf,s);
			}
	#endif
			else{
				switch(t){
				case 'c': {TYPE c=(TYPE)va_arg(ap,int); do_toput_char(buf,c);} break;
				case 'u': {uint n=(uint)va_arg(ap,unsigned int); merge(do_,TOWRITE(_uint))(buf,n);} break;
				case 'x': {uint n=(uint)va_arg(ap,unsigned int); merge(do_,TOWRITE(_hex))(buf,n);} break;
				case 'i': {ssint n=(ssint)va_arg(ap,int); merge(do_,TOWRITE(_ssint))(buf,n);} break;
				case 'f': {double f=va_arg(ap,double); merge(do_,TOWRITE(_double))(buf,f);} break;
				case '%': default: do_toput_char(buf,*ps);	//Any other character prints itself
				}
				to_checkflush(buf);
			}
		}
	}
	va_end(ap);
}
#endif

#endif

