﻿void mmulrot_ptr(double B[], double C[], double A[]){
	zeroset_double(A,9);
	for(cint it=3;it;){ it--;
		cint jt=3;
		do{ double aux; jt--;
			aux=*B++;
			*A+++=aux**C++;
			*A+++=aux**C++;
			*A+=aux**C++;	A-=2;
		}while(jt);
		A+=3, C-=9;
	}
}
sinline void mmulrot(double B[][3], double C[][3], double A[][3]){
	mmulrot_ptr(B[0],C[0],A[0]);
}

void mmulrot_inv_ptr(double B[], double C_inv[], double A[]){
	for(cint it=3;it;){ it--;
		cint jt=3;
		do{ double aux;
			jt--;
			aux=*B++**C_inv++;
			aux+=*B++**C_inv++;
			aux+=*B**C_inv++;	B-=2;
			*A++=aux;
		}while(jt);
		B+=3, C_inv-=9;
	}
}
sinline void mmulrot_inv(double B[][3], double C_inv[][3], double A[][3]){
	mmulrot_inv_ptr(B[0],C_inv[0],A[0]);
}

#define test(x,y,res) (fabs((x)-(y))>((x)+(y))*res)	//> instead of >= just in case both of them are zero
//When the zero is at the middle of the scale: ond, xO, yS y φ0, the test is just for accomodating possible
//rounding differrences of floating point numbers.
bint cmp_Sistema(const Sistema* sis1,const Sistema *sis2){
	if(sis1->sis.proy!=sis2->sis.proy) return 1;
	if(sis1->sis.proy==SIS_Rectangular) return 0;
	if(test(sis1->sis.ond ,sis2->sis.ond,1.0E-5)) return 1;
	if(test(sis1->sis.a,sis2->sis.a,1.0E-9)) return 1;
	if(sis1->sis.proy!=SIS_Conforme){
		if(fabs(sis1->sis.e-sis2->sis.e)>1.0E-9) return 1;
		if(test(sis1->sis.Λ0,sis2->sis.Λ0,1.0E-9)) return 1;
	}else{
		if(test(sis1->sis.e,sis2->sis.e,1.0E-9)) return 1;
	}
	if(sis1->sis.proy==SIS_Geograficas){
		if(sis1->sis.param1.orden_λφ!=sis2->sis.param1.orden_λφ) return 1;
		return 0;
	}

	if(test(sis1->sis.k0,sis2->sis.k0,1.0E-9)) return 1;
	if(sis1->sis.proy==SIS_Conforme){
		if(test(sis1->sis.e,sis2->sis.e,1.0E-9)) return 1;
		if(sis1->sis.a!=sis1->sis.e){
			if(test(sis1->sis.param1.conv0,sis2->sis.param1.conv0,1.0E-7)) return 1;
		}
		return 0;
	}
	if(test(sis1->sis.yS,sis2->sis.yS,1.0E-10)) return 1;
	if(sis1->sis.proy!=SIS_Mercator && test(sis1->sis.xO,sis2->sis.xO,1.0E-10)) return 1;
	if(sis1->sis.proy==SIS_Lambert && test(sis1->sis.param1.φ0,sis2->sis.param1.φ0,1.0E-9)) return 1;
	return 0;
}
#undef test

void setup_Sistema(Sistema *sis){
	if(sis->sis.proy==SIS_Rectangular) return;

	NOTFINITE_d(sis->local.proy.x); NOTFINITE_d(sis->local.proy.y);
	NOTFINITE_d(sis->local.geog.λ); NOTFINITE_d(sis->local.proy.φ);
	NOTFINITE_d(sis->local.geoc.X); NOTFINITE_d(sis->local.geoc.Y); NOTFINITE_d(sis->local.geoc.Z);
	if(sis->sis.proy==SIS_Conforme) return;

	if(sis->sis.proy==SIS_Geograficas) sis->sis.k0=1/PI_180;
	sis->precalc.Comun.ak0=sis->sis.a*sis->sis.k0;
	if(sis->sis.proy==SIS_Geograficas) return;

	if(sis->sis.proy==SIS_Estereográfica){
		if(sis->sis.param1.φ0==90) sis->sis.proy=SIS_Estereográfica_Polar;
		else if(sis->sis.param1.φ0==-90) sis->sis.proy=SIS_Estereográfica_Polar;
	}
	switch(sis->sis.proy){
	case SIS_Lambert:{
		double sinφ0;
		sis->precalc.Lambert.φ0=sis->sis.param1.φ0*PI_180;
		sis->precalc.Lambert.sinφ0=sinφ0=sin(sis->precalc.Lambert.φ0);
		sis->precalc.Lambert.R0=radN(sis->precalc.Comun.ak0,sis->sis.e,sinφ0);
		sis->precalc.Lambert.R0/=tan(sis->precalc.Lambert.φ0);
		sis->precalc.Lambert.d=rST2_sinφ(sis->sis.e,sinφ0);
		sis->precalc.Lambert.c=sis->precalc.Lambert.R0*pow(sis->precalc.Lambert.d,0.5*sis->precalc.Lambert.sinφ0);
	} break;
	case SIS_Estereográfica_Polar:{
		if(sis->sis.param1.φ0!=90) sis->sis.param1.φ0=-90; //Si el usuario no ha indicado explícitamente hemisferio Norte, la creamos de hemisferio Sur.
		double K;
		//0.5*ee*log{(1+ee)/(1-ee)}+0.5*log(1-e)
		//log(k) en e Polo si no se corrigiese
		K=sis->sis.e/56;
		K=sis->sis.e*(1.0/30+K);
		K=sis->sis.e*(1.0/12+K);
		K=sis->sis.e*(0.5+K);
		//guardamos 1/k(Polo)
		K=exp(-K);
		//Al multiplicar por esto quedará k(polo)=1.
		sis->precalc.Estereografica.K=2*K*sis->precalc.Comun.ak0;
	} break;
	case SIS_Estereográfica:{
		double φ0=sis->sis.param1.φ0*PI_180;
		Puntoxy_double p=sinΦcosΦ___φ(sis->sis.e,φ0);
		sis->precalc.EstereoOblicua.sinΦ0=p.x;
		sis->precalc.EstereoOblicua.cosΦ0=p.y;
		double K=kΦ___φ(sis->sis.e,φ0); //k de aΦ <-- ρφ en φ0.
		sis->precalc.EstereoOblicua.K=2*sis->precalc.Comun.ak0/K;
	} break;
	case SIS_Mercator_Transversa:
		sis->precalc.UTM.e_div_1minus_e=sis->sis.e/(1-sis->sis.e);
	break;
	}
}

//Λ0 en grados
void setup_Sistema_UTM_Norte(Sistema *sis, double Λ0){
	sis->sis.proy=SIS_Mercator_Transversa;
	sis->sis.a=GRS80_a;
	sis->sis.e=GRS80_e;
	sis->sis.ond=0;
	sis->sis.Λ0=Λ0*PI_180;
	sis->sis.k0=0.9996;
	sis->sis.xO=500000;
	sis->sis.yS=0;
	setup_Sistema(sis);
	sis->infor.λ0=Λ0;
}
//Λ0 en grados
void setup_Sistema_UTM_Sur(Sistema *sis, double Λ0){
	sis->sis.proy=SIS_Mercator_Transversa;
	sis->sis.a=GRS80_a;
	sis->sis.e=GRS80_e;
	sis->sis.ond=0;
	sis->sis.Λ0=Λ0*PI_180;
	sis->sis.k0=0.9996;
	sis->sis.xO=500000.0;
	sis->sis.yS=4000000.0;
	setup_Sistema(sis);
	sis->infor.λ0=Λ0;
}
//Λ0 en grados
void setup_Sistema_Estereo_Norte(Sistema *sis, double Λ0){
	sis->sis.proy=SIS_Estereográfica_Polar;
	sis->sis.a=Tierra_RPolar;
	sis->sis.e=0;
	sis->sis.ond=0;
	sis->sis.Λ0=Λ0*PI_180;
	sis->sis.k0=1;
	sis->sis.xO=0;
	sis->sis.yS=0;
	sis->sis.param1.φ0=90.0;
	setup_Sistema(sis);
	sis->infor.λ0=Λ0;
}
//Λ0 en grados
void setup_Sistema_Estereo_Sur(Sistema *sis, double Λ0){
	sis->sis.proy=SIS_Estereográfica_Polar;
	sis->sis.a=Tierra_RPolar;
	sis->sis.e=0;
	sis->sis.ond=0;
	sis->sis.Λ0=Λ0*PI_180;
	sis->sis.k0=1;
	sis->sis.xO=0;
	sis->sis.yS=0;
	sis->sis.param1.φ0=-90.0;
	setup_Sistema(sis);
	sis->infor.λ0=Λ0;
}
//Λ0 en grados
void setup_Sistema_Estereográfica(Sistema *sis, double φ0, double Λ0){
	sis->sis.proy=SIS_Estereográfica;
	sis->sis.a=GRS80_a;
	sis->sis.e=GRS80_e;
	sis->sis.ond=0;
	sis->sis.Λ0=Λ0*PI_180;
	sis->sis.k0=1;
	sis->sis.xO=0;
	sis->sis.yS=0;
	sis->sis.param1.φ0=φ0;
	setup_Sistema(sis);
	sis->infor.λ0=Λ0;
}
//Λ0 en grados
void setup_Sistema_Sinusoidal(Sistema *sis, double Λ0){
	sis->sis.proy=SIS_Sinusoidal;
	sis->sis.a=Tierra_R;
	sis->sis.e=0;
	sis->sis.ond=0;
	sis->sis.Λ0=Λ0*PI_180;
	sis->sis.k0=1;
	sis->sis.xO=0;
	sis->sis.yS=0;
	sis->sis.param1.eqsim.ky=1;
	sis->sis.param1.eqsim.α=1;
	setup_Sistema(sis);
	sis->infor.λ0=Λ0;
}
//Λ0 en grados
void setup_Sistema_Sinusoidal_ex(Sistema *sis, double Λ0, double ky, double α){
	sis->sis.proy=SIS_Sinusoidal;
	sis->sis.a=Tierra_R;
	sis->sis.e=0;
	sis->sis.ond=0;
	sis->sis.Λ0=Λ0*PI_180;
	sis->sis.k0=1;
	sis->sis.xO=0;
	sis->sis.yS=0;
	sis->sis.param1.eqsim.ky=ky;
	sis->sis.param1.eqsim.α=α;
	setup_Sistema(sis);
	sis->infor.λ0=Λ0;
}

//Calcula la matriz que transforma de geocéntricas al sistema local: local=MT*geoc
void calcula_matrizMT(double (*MT)[3],const Sistema *sis){
	double sinφ1,cosφ1,sinλ1,cosλ1;
	sinφ1=sin(sis->local.geog.φ);
	cosφ1=cos(sis->local.geog.φ);
	sinλ1=sin(sis->local.geog.λ);
	cosλ1=cos(sis->local.geog.λ);
	MT[0][0]=-sinλ1;			MT[0][1]=cosλ1;			MT[0][2]=0;
	MT[1][0]=-sinφ1*cosλ1;	MT[1][1]=-sinφ1*sinλ1;	MT[1][2]=cosφ1;
	MT[2][0]=cosφ1*cosλ1;	MT[2][1]=cosφ1*sinλ1;	MT[2][2]=sinφ1;
	if(sis->local.conv1!=0){
		double cost1,sint1;
		double M[2][3];
		cost1=cos(sis->local.conv1);
		sint1=sin(sis->local.conv1);
		M[0][0]=cost1*MT[0][0]-sint1*MT[1][0];
		M[0][1]=cost1*MT[0][1]-sint1*MT[1][1];
		M[0][2]=-sint1*MT[1][2];
		M[1][0]=sint1*MT[0][0]+cost1*MT[1][0];
		M[1][1]=sint1*MT[0][1]+cost1*MT[1][1];
		M[1][2]=cost1*MT[1][2];
		memcpy_double(MT[0],M[0],6);
	}
}
