﻿void XYZlocal___geo_p(PuntoXYZ_double** puntos,uint n, Sistema* sis){
	double e,e1;
	double MT[3][3];

	calcula_matrizMT(MT,sis);
	e=sis->sis.e;
	e1=1-e;

	if(!isfinite(sis->local.geoc.X)){
		double N0,aux,sinφ1;
		sinφ1=sin(sis->local.geog.φ);
		N0=radN(sis->sis.a,e,sinφ1);
		aux=N0*cos(sis->local.geog.φ);
		sis->local.geoc.X=aux*cos(sis->local.geog.λ);
		sis->local.geoc.Y=aux*sin(sis->local.geog.λ);
		sis->local.geoc.Z=N0*e1*sinφ1;
	}

	dontimes(n,puntos++){
		double λ,φ,z,sinφ,N,aux,x,y;
		λ=(*puntos)->X;
		φ=(*puntos)->Y;
		z=(*puntos)->Z;
		sinφ=sin(φ);
		N=radN(sis->sis.a,e,sinφ);
		aux=(N+z)*cos(φ);
		x=aux*cos(λ);
		y=aux*sin(λ);
		z=(N*e1+z)*sinφ;

		x-=sis->local.geoc.X;
		y-=sis->local.geoc.Y;
		z-=sis->local.geoc.Z;
		(*puntos)->X=MT[0][0]*x+MT[0][1]*y+MT[0][2]*z;
		(*puntos)->Y=MT[1][0]*x+MT[1][1]*y+MT[1][2]*z;
		(*puntos)->Z=MT[2][0]*x+MT[2][1]*y+MT[2][2]*z;
	}
}

//los puntos tienen que venir en geográficas
//sentido: fwd: de la proyección al sistema local a la proyección; bwd: del sistema local a la proyección
void transforma_rotaciones_p(PuntoXYZM_double** centros,uint n, const Sistema* sis, bint sentido){
	double cosφ1,sinφ1,cost1,sint1;

	cosφ1=cos(sis->local.geog.φ);
	sinφ1=sin(sis->local.geog.φ);
	cost1=1; sint1=0;
	if(sis->local.conv1!=0){
		cost1=cos(sis->local.conv1);
		sint1=sin(sis->local.conv1);
	}
	dontimes(n,centros++){
		double φ,λ,cosφ,sinφ,cosλ,sinλ;
		double MC[3][3]; //Matriz que pasa del sistema local a la proyección
		double t;

		φ=(*centros)->P.Y;
		λ=sis->local.geog.λ-(*centros)->P.X;
		cosφ=cos(φ);	sinφ=sin(φ);
		cosλ=cos(λ);	sinλ=sin(λ);
		t=conv_meridianos(sis,(*centros)->P.X,φ);

		MC[0][0]=cosλ;				MC[0][1]=-sinφ1*sinλ;	MC[0][2]=cosφ1*sinλ;
		MC[1][0]=sinφ*sinλ;
		{double aux=-sinφ*cosλ;	MC[1][1]=-sinφ1*aux+cosφ1*cosφ;	MC[1][2]=cosφ1*aux+sinφ1*cosφ;}
		MC[2][0]=-cosφ*sinλ;
		{double aux=cosφ*cosλ;		MC[2][1]=-sinφ1*aux+cosφ1*sinφ;	MC[2][2]=cosφ1*aux+sinφ1*sinφ;}

		//En este caso hacemos MC = Mt*MC*M(-t1).
		if(sint1!=0 || t!=0){
			double cost,sint;
			double M[3][3];
			double *pA, *pB;
			cost=cos(t);
			sint=sin(t);	//Mt*MC*M(-t1)
			M[0][0]=cost*MC[0][0]-sint*MC[1][0];
			M[0][1]=cost*MC[0][1]-sint*MC[1][1];
			M[0][2]=cost*MC[0][2]-sint*MC[1][2];
			M[1][0]=sint*MC[0][0]+cost*MC[1][0];
			M[1][1]=sint*MC[0][1]+cost*MC[1][1];
			M[1][2]=sint*MC[0][2]+cost*MC[1][2];
			memcpy_double(M[2],MC[2],3);

			pA=MC[0]; pB=M[0];
			*pA++=cost1**pB-sint1**(pB+1);
			*pA++=sint1**pB+cost1**(pB+1);
			*pA++=*(pB+2);	pB+=3;
			*pA++=cost1**pB-sint1**(pB+1);
			*pA++=sint1**pB+cost1**(pB+1);
			*pA++=*(pB+2);	pB+=3;
			*pA++=cost1**pB-sint1**(pB+1);
			*pA++=sint1**pB+cost1**(pB+1);
			*pA++=*(pB+2);	pB+=3;
		}

		double ML[3][3];
		if(sentido==fwd){mmulrot((*centros)->M,MC,ML);}
		else{mmulrot_inv((*centros)->M,MC,ML);}
		memcpy_double((*centros)->M[0],ML[0],9);
	}
}

int geo___XYZlocal_p(PuntoXYZ_double** puntos,uint n,const Sistema* sis){
	int error;
	double e,e1;
	double MT[3][3];
	double tol;
	error=0;

	calcula_matrizMT(MT,sis);
	e=sis->sis.e;
	e1=1-e;
	tol=sis->sis.a*1E-8;

	dontimes(n,puntos++){
		double x,y,z,X,Y,Z,S,λ,φ;
		x=(*puntos)->X;
		y=(*puntos)->Y;
		z=(*puntos)->Z;

		X=MT[0][0]*x+MT[1][0]*y+MT[2][0]*z;
		Y=MT[0][1]*x+MT[1][1]*y+MT[2][1]*z;
		Z=MT[0][2]*x+MT[1][2]*y+MT[2][2]*z;
		X+=sis->local.geoc.X;
		Y+=sis->local.geoc.Y;
		Z+=sis->local.geoc.Z;

		S=sqrt(X*X+Y*Y);
		λ=atan2(Y,X);
		Z/=(e1*S);
		z=0;
		φ=atan(Z);
		cint it=6;
		do{ it--;
			double N,cosφ,sinφ,aux,φφ,zz,auxb;
			sinφ=sin(φ);
			cosφ=cos(φ);
			N=radN(sis->sis.a,e,sinφ);
			zz=S*(cosφ+Z*sinφ)-N;
			zz/=1-cosφ*cosφ*e;
			aux=(N+zz)/(N+e1*zz);
			zz*=e1;
			φφ=atan2(Z,aux);
			aux=fabs(zz-z);
			auxb=fabs(φφ-φ);
			z=zz; φ=φφ;
			if(aux<tol && auxb<1e-8) break;
		}while(it);
		if(it==0) error=1;

		(*puntos)->X=λ;
		(*puntos)->Y=φ;
		(*puntos)->Z=z;
	}
	return error;
}

//Las coordenadas estereográficas se tratan como del Hemisferio Sur.
int geo___proy_p(Puntoxy_double** puntos,uint n,const Sistema* sis){
	Puntoxy_double** pP;
	double e;

	if(Sistema_has_xOyS(sis->sis.proy)){
		pP=puntos;
		dontimes(n,pP++){
			(*pP)->x-=sis->sis.xO;
			(*pP)->y-=sis->sis.yS;
	}	}

	pP=puntos;
	e=sis->sis.e;
	switch(sis->sis.proy){
	case SIS_Geograficas:{
		if(sis->sis.param1.orden_λφ==SIS_Geograficas_φλ){
			dontimes(n,pP++){
				double φ=(*pP)->x*PI_180;
				(*pP)->λ=(*pP)->y*PI_180;
				(*pP)->φ=φ;
			}
		}else{
			dontimes(n,pP++){
				(*pP)->x*=PI_180;
				(*pP)->y*=PI_180;
			}
		}
	} break;
	case SIS_Lambert:{
		double _R0,_sinφ0,d0;
		_R0=1/sis->precalc.Lambert.R0;
		_sinφ0=1/sis->precalc.Lambert.sinφ0;
		d0=(1+sis->precalc.Lambert.sinφ0)/(1-sis->precalc.Lambert.sinφ0);

		//d0 para el valor inicial en lugar de d.
		{double aux=2*e*cos(sis->precalc.Lambert.φ0)/(1-e*sis->precalc.Lambert.sinφ0*sis->precalc.Lambert.sinφ0);
		aux=1+aux*(sis->local.geog.φ-sis->precalc.Lambert.φ0);
		d0*=aux;}	//Para un v.i. igual a local.geog.φ este es el valor óptimo.

		dontimes(n,pP++){
			double E,N,c,sinφ;
			E=(*pP)->x*_R0;
			N=1-(*pP)->y*_R0;
			(*pP)->λ=atan2(E,N)*_sinφ0;
			c=E*E+N*N; //R^2
			c=pow(c,-_sinφ0);
			sinφ=(c*d0-1)/(c*d0+1);
			c*=sis->precalc.Lambert.d;
			(*pP)->φ=φ___rST2_sinφapprox(e,c,sinφ);
		}
	} break;
	case SIS_Mercator:{
		double _ak0=1/sis->precalc.Comun.ak0;
		dontimes(n,pP++){
			double ΦM=(*pP)->y*_ak0;
			(*pP)->φ=φ___ΦM(sis->sis.e,ΦM);
			(*pP)->λ*=_ak0;
		}
	} break;
	case SIS_Estereográfica_Polar:{
		double _K,d0;
		_K=1/sis->precalc.Estereografica.K;
		d0=ΦM_ajuste_e(sis->sis.e,sin(sis->local.geog.φ));
		d0=exp(-d0);

		dontimes(n,pP++){
			double c,sinφ, E,N;
			E=(*pP)->x*_K;
			N=(*pP)->y*_K;
			c=E*E+N*N;
			{double aux=c*d0;
			sinφ=(aux-1)/(aux+1);}
			(*pP)->λ=atan2(E,N);
			(*pP)->φ=φ___rST2_sinφapprox(sis->sis.e,c,sinφ);
		}
		if(sis->sis.param1.φ0==90){
			pP=puntos;
			dontimes(n,pP++){
				if((*pP)->λ>=0) (*pP)->λ=-(*pP)->λ+PI;  else (*pP)->λ=-(*pP)->λ-PI;
				(*pP)->φ=-(*pP)->φ;
		}	}
	} break;
	case SIS_Estereográfica:{
		double _K=1/sis->precalc.EstereoOblicua.K;
		dontimes(n,pP++){
			double x,y,z,sΦ,cλcΦ;
			x=(*pP)->x*_K;
			y=(*pP)->y*_K;
			z=x*x+y*y;
			z=2/(1+z);
			x*=z; y*=z;
			z=z-1;

			sΦ=y*sis->precalc.EstereoOblicua.cosΦ0+z*sis->precalc.EstereoOblicua.sinΦ0;
			cλcΦ=-y*sis->precalc.EstereoOblicua.sinΦ0+z*sis->precalc.EstereoOblicua.cosΦ0;
			(*pP)->λ=atan2(x,cλcΦ); //x=sλ*cφ
			(*pP)->φ=φ___sinΦ(sis->sis.e,sΦ);
		}
	}
	break;
	case SIS_Mercator_Transversa:{
		dontimes(n,pP++){
			**pP=UTM_λφ___xy(sis->precalc.Comun.ak0,e,**pP);
		}
	} break;
	case SIS_Sinusoidal:{
		double _ak0=1/sis->precalc.Comun.ak0;
		if(sis->sis.param1.eqsim.ky!=1.0){
			double _ky=1.0/sis->sis.param1.eqsim.ky;
			dontimes(n,pP++) (*pP)->y*=_ky;
			pP=puntos;
		}
		if(sis->sis.param1.eqsim.α==1.0){
			dontimes(n,pP++){
				(*pP)->x*=_ak0;
				(*pP)->y*=_ak0;
				double c=cos((*pP)->φ); c+=(c==0);
				(*pP)->λ/=c;
			}
		}else{
			dontimes(n,pP++){
				(*pP)->x*=_ak0;
				(*pP)->y*=_ak0;
				double c=1-cos((*pP)->φ);
				c=1-sis->sis.param1.eqsim.α*c;
				c+=(c==0);
				(*pP)->λ/=c;
			}
		}
	} break;
	}

	if(sis->sis.Λ0!=0){
		durchlaufei(Puntoxy_double*,puntos,n) (*ptri)->λ+=sis->sis.Λ0;
	}
	return 0;
}

int geo___proyL_p(Puntoxy_double** puntos,uint n,Sistema* sis){
	if(!isfinite(sis->local.geog.λ) && isfinite(sis->local.proy.x)){
		sis->local.geog=geo___proy1(sis,sis->local.proy);
		sis->local.conv1=conv_meridianos(sis,sis->local.geog.λ,sis->local.geog.φ);
	}
	return geo___proy_p(puntos,n,sis);
}

int proy___geo_p(Puntoxy_double** puntos,uint n,const Sistema *sis){
	double e;
	Puntoxy_double **pP;

	if(sis->sis.Λ0!=0){
		durchlaufei(Puntoxy_double*,puntos,n) (*ptri)->λ-=sis->sis.Λ0;
	}

	pP=puntos;
	e=sis->sis.e;
	switch(sis->sis.proy){
	case SIS_Geograficas:{
		if(sis->sis.param1.orden_λφ==SIS_Geograficas_φλ){
			dontimes(n,pP++){
				double y=(*pP)->λ*PI_180_PI;
				(*pP)->x=(*pP)->φ*PI_180_PI;
				(*pP)->y=y;
			}
		}else{
			dontimes(n,pP++){
				(*pP)->λ*=PI_180_PI;
				(*pP)->φ*=PI_180_PI;
			}
		}
	} return 0;
	case SIS_Lambert:{
		dontimes(n,pP++){
			double λ,sinφ,b,R;
			λ=(*pP)->λ*sis->precalc.Lambert.sinφ0;
			sinφ=sin((*pP)->φ);
			b=rST2_sinφ(sis->sis.e,sinφ);
			b=pow(b,-0.5*sis->precalc.Lambert.sinφ0);

			R=sis->precalc.Lambert.c*b;
			(*pP)->x=R*sin(λ);
			(*pP)->y=sis->precalc.Lambert.R0-R*cos(λ);
		}
	} break;
	case SIS_Mercator:{
		dontimes(n,pP++){
			(*pP)->λ*=sis->precalc.Comun.ak0;
			(*pP)->y=ΦM___sinφ(sis->sis.e,sin((*pP)->φ));
			(*pP)->y*=sis->precalc.Comun.ak0;
		}
	} break;
	case SIS_Estereográfica_Polar:{
		if(sis->sis.param1.φ0==90){ //h. Norte
			dontimes(n,pP++){
				double R=sis->precalc.Estereografica.K*rST_φ(sis->sis.e,-(*pP)->φ);
				(*pP)->y=-R*cos((*pP)->λ);
				(*pP)->x=R*sin((*pP)->λ);
			}
		}else{ //h. Sur
			dontimes(n,pP++){
				double R=sis->precalc.Estereografica.K*rST_φ(sis->sis.e,(*pP)->φ);
				(*pP)->y=R*cos((*pP)->λ);
				(*pP)->x=R*sin((*pP)->λ);
			}
		}
	} break;
	case SIS_Estereográfica:{
		dontimes(n,pP++){
			double C,z;
			Puntoxy_double Δ=sinΦcosΦ___φ(sis->sis.e,(*pP)->φ);

			C=Δ.y*cos((*pP)->λ);
			(*pP)->x=Δ.y*sin((*pP)->λ);
			z=		   Δ.x*sis->precalc.EstereoOblicua.sinΦ0 + C*sis->precalc.EstereoOblicua.cosΦ0;
			(*pP)->y=Δ.x*sis->precalc.EstereoOblicua.cosΦ0 - C*sis->precalc.EstereoOblicua.sinΦ0;
			C=sis->precalc.EstereoOblicua.K/(1+z);
			(*pP)->x*=C;
			(*pP)->y*=C;
		}
	}
	case SIS_Mercator_Transversa:{
		dontimes(n,pP++){
			**pP=UTM_xy___λφ(sis->precalc.Comun.ak0,e,**pP);
		}
	} break;
	case SIS_Sinusoidal:{
		if(sis->sis.param1.eqsim.α==1.0){
			dontimes(n,pP++){
				(*pP)->x*=cos((*pP)->φ);
				(*pP)->x*=sis->precalc.Comun.ak0;
				(*pP)->y*=sis->precalc.Comun.ak0;
			}
		}else{
			dontimes(n,pP++){
				double x=1-cos((*pP)->φ);
				(*pP)->x*=1-sis->sis.param1.eqsim.α*x;
				(*pP)->x*=sis->precalc.Comun.ak0;
				(*pP)->y*=sis->precalc.Comun.ak0;
			}
		}
		if(sis->sis.param1.eqsim.ky!=1.0){
			pP=puntos;
			dontimes(n,pP++) (*pP)->y*=sis->sis.param1.eqsim.ky;
		}
	} break;
	default:
		return 0;
	}

	if(sis->sis.xO!=0 || sis->sis.yS!=0){
		pP=puntos;
		dontimes(n,pP++){
			(*pP)->x+=sis->sis.xO;
			(*pP)->y+=sis->sis.yS;
	}	}

	return 0;
}

void XYZlocal___conformelocal_p(bint escentros, PuntoXYZM_double** puntos,uint n, Sistema *sis){
	bint bgira;
	double _a,_e,_k0,cost,sint;

	if(!isfinite(sis->local.geog.λ)){
		sis->local.geoc.X=sis->local.geog.λ=sis->local.proy.x;
		sis->local.geoc.Y=sis->local.geog.φ=sis->local.proy.y;
		sis->local.conv1=sis->sis.param1.conv0*PI_180;
	}
	_a=1/sis->sis.a;	_e=1/sis->sis.e;	_k0=1/sis->sis.k0;
	if(sis->sis.a!=sis->sis.e && sis->local.conv1!=0) bgira=1;
	else bgira=0;
	if(bgira){
		double aux=sis->local.conv1;
		cost=cos(aux);
		sint=sin(aux);
	}
	{dontimes(n,){
		PuntoXYZM_double *pP=*puntos++;
		double E,N,h,xx,xy,yy;
		double MT[3][3], MMT[3][3];

		E=pP->P.X-sis->local.geoc.X;
		N=pP->P.Y-sis->local.geoc.Y;
		h=pP->P.Z+sis->sis.ond;
		E*=_k0;
		N*=_k0;
		//Giramos, para tener los ejes según las direcciones de curvaturas principales
		if(bgira){
			double aux=cost*E+sint*N;
			N=-sint*E+cost*N;
			E=aux;
		}
		pP->P.X=E*(1+h*_a);
		pP->P.Y=N*(1+h*_e);
		pP->P.Z-=0.5*(E*E*_a+N*N*_e);
		//Quitamos el giro
		if(bgira){
			double aux=cost*pP->P.X-sint*pP->P.Y;
			pP->P.Y=sint*pP->P.X+cost*pP->P.Y;
			pP->P.X=aux;
		}

		if(!escentros) continue;
		E*=_a;
		N*=_e;
		xx=E*E*0.5;
		yy=N*N*0.5;
		xy=E*N*0.5;

		MT[0][0]=1-xx;	MT[0][1]=-xy;	MT[0][2]=E;
		MT[1][0]=-xy;	MT[1][1]=1-yy;	MT[1][2]=N;
		MT[2][0]=-E;	MT[2][1]=-N;	MT[2][2]=1-(xx+yy);

		if(bgira){
			double Mk[3][3];
			Mk[0][2]=Mk[2][0]=Mk[1][2]=Mk[2][1]=0;
			Mk[2][2]=1;
			Mk[0][0]=Mk[1][1]=cost;
			Mk[0][1]=sint;
			Mk[1][0]=-sint;

			mmulrot(MT,Mk,MMT);
			Mk[0][1]=-sint;
			Mk[1][0]=sint;
			mmulrot(Mk,MMT,MT);
		}
		mmulrot_inv(pP->M,MT,MMT);
		memcpy_double(pP->M[0],MMT[0],9);
	}}
}
void conformelocal___XYZlocal_p(bint escentros, PuntoXYZM_double** puntos,uint n, const Sistema *sis){
	bint bgira;
	double _a,_e,cost,sint;

	_a=1/sis->sis.a;	_e=1/sis->sis.e;
	if(sis->sis.a!=sis->sis.e && sis->local.conv1!=0) bgira=1;
	else bgira=0;
	if(bgira){
		double aux=sis->local.conv1;
		cost=cos(aux);
		sint=sin(aux);
	}
	{dontimes(n,){
		PuntoXYZM_double *pP=*puntos++;
		double E,N,h,x,y,z,xx,xy,yy;
		double MT[3][3], MMT[3][3];

		E=x=pP->P.X;
		N=y=pP->P.Y;
		if(bgira){
			x=cost*E+sint*N;
			N=y=-sint*E+cost*N;
			E=x;
		}
		h=z=pP->P.Z;
		dontimes(3,){
			double s=E*E*_a+N*N*_e;
			h=z+s*0.5;
			E=x/(1+h*_a);
			N=y/(1+h*_a);
		}
		if(bgira){
			pP->P.X=cost*E-sint*N;
			pP->P.Y=sint*E+cost*N;
		}else{
			pP->P.X=E;
			pP->P.Y=N;
		}
		pP->P.X=pP->P.X*sis->sis.k0+sis->local.geoc.X;
		pP->P.Y=pP->P.Y*sis->sis.k0+sis->local.geoc.Y;
		pP->P.Z=h-sis->sis.ond;

		if(!escentros) continue;
		E*=_a;
		N*=_e;
		xx=E*E*0.5;
		yy=N*N*0.5;
		xy=E*N*0.5;

		MT[0][0]=1-xx;	MT[0][1]=-xy;	MT[0][2]=E;
		MT[1][0]=-xy;	MT[1][1]=1-yy;	MT[1][2]=N;
		MT[2][0]=-E;	MT[2][1]=-N;	MT[2][2]=1-(xx+yy);

		if(bgira){
			double Mk[3][3];

			Mk[0][2]=Mk[2][0]=Mk[1][2]=Mk[2][1]=0;
			Mk[2][2]=1;
			Mk[0][0]=Mk[1][1]=cost;
			Mk[0][1]=sint;
			Mk[1][0]=-sint;

			mmulrot(MT,Mk,MMT);
			Mk[0][1]=-sint;
			Mk[1][0]=sint;
			mmulrot(Mk,MMT,MT);
		}
		mmulrot(pP->M,MT,MMT);
		memcpy_double(pP->M[0],MMT[0],9);
	}}
}

void XYZlocal___proy_p(bint soncentros, PuntoXYZM_double** centros,uint n, Sistema *sis){
	if(sis->sis.proy==SIS_Rectangular) return;
	if(sis->sis.proy==SIS_Conforme){
		XYZlocal___conformelocal_p(soncentros,centros,n,sis);
		return;
	}

	if(sis->sis.ond!=0){
		PuntoXYZ_double **pP=(PuntoXYZ_double**)centros;
		{dontimes(n,pP++){
			(*pP)->Z+=sis->sis.ond;
		}}
	}
	geo___proyL_p((Puntoxy_double**)centros,n,sis);
	if(soncentros) transforma_rotaciones_p(centros,n,sis,fwd);
	XYZlocal___geo_p((PuntoXYZ_double**)centros,n,sis);
}
int proy___XYZlocal_p(bint soncentros, PuntoXYZM_double** centros,uint n, const Sistema* sis){
	int error;
	if(sis->sis.proy==SIS_Rectangular) return 0;
	if(sis->sis.proy==SIS_Conforme){
		conformelocal___XYZlocal_p(soncentros,centros,n,sis);
		return 0;
	}

	error=geo___XYZlocal_p((PuntoXYZ_double**)centros,n,sis);
	if(soncentros) transforma_rotaciones_p(centros,n,sis,back);
	error|=proy___geo_p((Puntoxy_double**)centros,n,sis);
	if(sis->sis.ond!=0){
		PuntoXYZ_double **pP=(PuntoXYZ_double**)centros;
		{dontimes(n,pP++){
			(*pP)->Z+=sis->sis.ond;
		}}
	}
	return error;
}
