#pragma once
#define ATCRT_TYPES_ONLY
#include <ATcrt/ATsystem.h>
#undef ATCRT_TYPES_ONLY
#include <ATcrt/ATmemstr.h>
#include <math.h>
#include <malloc.h> //En Hel3D.c
#ifndef AT_NOMEM
#define AT_NOMEM -2
#endif
#include <ATmatrices/ATmatrices_macros.h>
#include "Estructuras2d3d.h"
#ifndef sinline
#define sinline static inline
#endif
#include "bucles_y_matrices3.h"
#include "rotacion.h"
#define TypeR float
#define Typ fl
#include "trans_Hel2D.h"
#include "trans_polinomica2D.h"
#include "trans_Hel3D.h"
#undef TypeR
#undef Typ
#define TypeR double
#define Typ dbl
#include "trans_Hel2D.h"
#include "trans_polinomica2D.h"
#include "trans_Hel3D.h"
#undef TypeR
#undef Typ


#ifndef __cplusplus

#ifdef GENERIC_NOT_IMPLEMENTED

//I assume that if float and double are the same size they are represented the same way
#define mmulrot(B,C,A)			sizeof(**(A))==sizeof(float) ? mmulrot_base_fl((float*)((B)[0]), (float*)((C)[0]), (float*)((A)[0])) : mmulrot_base_dbl((double*)((B)[0]), (double*)((C)[0]), (double*)((A)[0]))
#define mmulrot_inv(B,C,A)	sizeof(**(B))==sizeof(float) ? mmulrot_inv_base_fl((float*)((B)[0]), (float*)((C)[0]), (float*)((A)[0])) : mmulrot_inv_base_dbl((double*)((B)[0]), (double*)((C)[0]), (double*)((A)[0]))
#define MinversaRot(M)			sizeof(**(M))==sizeof(float) ? MinversaRot_fl((float (*)[3])M) : MinversaRot_dbl((double (*)[3])M)
#define Mtransponer(M,Mt)	sizeof(**(M))==sizeof(float) ? Mtransponer_fl((float (*)[3])M,(float (*)[3])Mt) : Mtransponer_dbl((double (*)[3])M,(double (*)[3])Mt)
#define ATinvsim3(N)				sizeof(*(N))==sizeof(float) ? ATinvsim3_fl((float*)N) : ATinvsim3_dbl((double*)N)

#else

#define mmulrot(B,C,A)			_Generic(*(A), float*: mmulrot_fl, double*: mmulrot_dbl)(B,C,A)
#define mmulrot_inv(B,C,A)	_Generic(*(B), float*: mmulrot_inv_fl, double*: mmulrot_inv_dbl)(B,C,A)
#define MinversaRot(M)			_Generic(*(M), float*: MinversaRot_fl, double*: MinversaRot_dbl)(M)
#define Mtransponer(M,Mt)	_Generic(*(M), float*: Mtransponer_fl, double*: Mtransponer_dbl)(M,Mt)
#define AutoGiraPunto(P,M)	_Generic(*(P), float: AutoGiraPunto_fl, double: AutoGiraPunto_dbl)(P,M)
#define AutoGiraPunto_inv(P,M)	_Generic(*(P), float: AutoGiraPunto_inv_fl, double: AutoGiraPunto_inv_dbl)(P,M)
#define GiraySumaM(P,M,C)	_Generic(*(P), float: GiraySumaM_fl, double: GiraySumaM_dbl)(P,M,C)
#define GiraySumaM_inv(P,M,C)	_Generic(*(P), float: GiraySumaM_inv_fl, double: GiraySumaM_inv_dbl)(P,M,C)
#define ATinvsim3(N)				_Generic(*(N), float: ATinvsim3_fl, double: ATinvsim3_dbl)(N)

#endif

#else //__cplusplus

inline void mmulrot(float B[][3], float C[][3], float A[][3]){mmulrot_fl(B,C,A);}
inline void ATinvsim3(float* N){ATinvsim3_fl(N);}

inline void mmulrot(double B[][3], double C[][3], double A[][3]){mmulrot_dbl(B,C,A);}
inline void ATinvsim3(double* N){ATinvsim3_dbl(N);}

#endif //__cplusplus
