﻿/*Necesita bucles_y_matrices_C.h (o _COMPILER.h)
Variantes con alguna dimensión igual a 3*/
#define ZEROCHECK_c ZEROCHECK_a

#define mmul_vector1_a3_open(TypeR,pA,OP,pB,pC,a) \
	cint it=a;\
	do{ it--;\
		TypeR aux=*pB++**pC++;\
		aux+=*pB++**pC++;\
		aux+=*pB++**pC; pC-=2;\
		*pA++ OP aux;\
	}while(it);
#define mmul_vector1_a3(TypeR,A,OP,B,v,a) \
	ZEROCHECK_a(a){TypeR *pA=A, *pB=B, *pC=v;\
		mmul_vector1_a3_open(TypeR,pA,OP,pB,pC,a) \
	}

#define mmul_vectorn_plus_3c_open(TypeR,pA,OP,pB,pC,c) \
	cint it=c;\
	do{ it--;\
		TypeR aux=*pC++;\
		*pA++ OP *pB++*aux;\
		*pA++ OP *pB++*aux;\
		*pA OP *pB++*aux; pA-=2;\
	}while(it);
#define mmul_vectorn_plus_3c(TypeR,A,OP,B,v,c) \
	ZEROCHECK_c(c){TypeR *pB=B, *pC=v, *pA=A;\
		mmul_vectorn_plus_3c_open(TypeR,pA,OP,pB,pC,c) \
	}

#define mmul_11_a3C_open(TypeR,pA,OP,pB,pC,a,c) \
	for(cint it=a;it;pB+=3){ it--;\
		cint jt=c;\
		do{ jt--;\
			TypeR aux=*pB++**pC++;\
			aux+=*pB++**pC++;\
			aux+=*pB**pC++;\
			*pA OP aux;\
			pB-=2, pA++;\
		}while(jt);\
		pC-=3*c;\
	}
#define mmul_11_a3C(TypeR,A,OP,B,C,a,c) \
	ZEROCHECK_c(c){TypeR *pA=A, *pB=B, *pC=C;\
		mmul_11_a3C_open(TypeR,pA,OP,pB,pC,a,c)\
	}

#define automul_11_a3a_open(TypeR,pA,OP,TypeRb,pB,a) \
	for(cint it=a;it;pB+=3){\
		TypeRb *pC=pB;\
		cint jt=it--;\
		do{ jt--;\
			TypeR aux=*pB++**pC++;\
			aux+=*pB++**pC++;\
			aux+=*pB**pC++;	pB-=2;\
			*pA+=aux;\
			pA++;\
		}while(jt);\
		pA+=a-it;\
	}
#define automul_11_a3a(TypeR,A,OP,TypeRb,B,a) \
	{TypeR *pA=A;\
	TypeRb *pB=B;\
	automul_11_a3a_open(TypeR,pA,OP,TypeRb,pB,a)\
	}

#define mmul_1n_plus_aB3_open(TypeR,pA,OP,pB,pC,a,b) \
	for(cint it=a;it;pA+=3){ it--;\
		cint jt=b;\
		do{ jt--;\
			TypeR aux=*pB++;\
			*pA++ OP aux**pC++;\
			*pA++ OP aux**pC++;\
			*pA OP aux**pC++;	pA-=2;\
		}while(jt);\
		pC-=b*3;\
	}
#define mmul_1n_plus_aB3(TypeR,A,OP,B,C,a,b) \
	ZEROCHECK_b(b){TypeR *pA=A, *pB=B, *pC=C;\
		mmul_1n_plus_aB3_open(TypeR,pA,OP,pB,pC,a,b)\
	}

#define mmul_nn_plus_Ab3_open(TypeR,pA,OP,pB,pC,a,b) \
	for(cint it=b;it;pC+=3){ it--;\
		cint jt=a;\
		do{ jt--;\
			TypeR aux=*pB++;\
			*pA++ OP aux**pC++;\
			*pA++ OP aux**pC++;\
			*pA++ OP aux**pC; pC-=2;\
		}while(jt);\
		pA-=a*3;\
	}
#define mmul_nn_plus_Ab3(TypeR,A,OP,B,C,a,b) \
	ZEROCHECK_a(a){TypeR *pB=B, *pC=C, *pA=A;\
		mmul_nn_plus_Ab3_open(TypeR,pA,OP,pB,pC,a,b)\
	}
#define simmul_nn_plus_3b3_open(TypeR,pA,OP,pB,pC,b) \
	for(cint it=b;it;){ it--;\
		{TypeR aux=*pB++;\
		*pA++ OP aux**pC++;\
		*pA++ OP aux**pC++;\
		*pA OP aux**pC;}	pC--;\
		pA+=2;\
		{TypeR aux=*pB++;\
		*pA++ OP aux**pC++;\
		*pA OP aux**pC;}\
		pA+=3;\
		*pA OP *pB++**pC++;\
		pA-=8;\
	}
#define simmul_nn_plus_3b3(TypeR,A,OP,B,C,b) \
	{TypeR *pA=A, *pB=B, *pC=C;\
	simmul_nn_plus_3b3_open(TypeR,pA,OP,pB,pC,b)\
	}

#define mmul_11_366_open(TypeR,A,OP,B,C) mmul_11_BC_open(TypeR,A,OP,B,C,3,6,6)
#define mmul_11_666_open(TypeR,A,OP,B,C) mmul_11_BC_open(TypeR,A,OP,B,C,6,6,6)
#define mmul_11_366(TypeR,A,OP,B,C) mmul_11_BC(TypeR,A,OP,B,C,3,6,6)
#define mmul_11_666(TypeR,A,OP,B,C) mmul_11_BC(TypeR,A,OP,B,C,6,6,6)
#define mmul_11_636_open(TypeR,pA,OP,pB,pC) mmul_11_a3C_open(TypeR,pA,OP,pB,pC,6,6)
#define mmul_11_633_open(TypeR,pA,OP,pB,pC) mmul_11_a3C_open(TypeR,pA,OP,pB,pC,6,3)
#define mmul_11_636(TypeR,A,OP,B,C) mmul_11_a3C(TypeR,A,OP,B,C,6,6)
#define mmul_11_633(TypeR,A,OP,B,C) mmul_11_a3C(TypeR,A,OP,B,C,6,3)
#define mmul_11_333(TypeR,A,OP,B,C) mmul_11_a3C(TypeR,A,OP,B,C,3,3)
#define automul_11_636(TypeR,A,OP,TypeRb,B) automul_11_a3a(TypeR,A,OP,TypeRb,B,6)
#define mmul_1n_plus_666_open(TypeR,pA,OP,pB,pC) mmul_1n_plus_BC_open(TypeR,pA,OP,pB,pC,6,6,6)
#define mmul_1n_plus_333_open(TypeR,pA,OP,pB,pC) mmul_1n_plus_aB3_open(TypeR,pA,OP,pB,pC,3,3)
#define mmul_1n_plus_663_open(TypeR,pA,OP,pB,pC) mmul_1n_plus_aB3_open(TypeR,pA,OP,pB,pC,6,6)
#define mmul_nn_plus_666_open(TypeR,pA,OP,pB,pC) mmul_nn_plus_AC_open(TypeR,pA,OP,pB,pC,6,6,6)
#define mmul_nn_plus_666(TypeR,A,OP,B,C) mmul_nn_plus_AC(TypeR,A,OP,B,C,6,6,6)

//B has extra three not multiplied
#define mmul_1n_plusB6_aB3_open(TypeR,pA,OP,pB,pC,a,b) \
	for(cint it=a;it;pA+=3){ it--;\
		cint jt=b;\
		do{ jt--;\
			TypeR aux=*pB++;\
			*pA++ OP aux**pC++;\
			*pA++ OP aux**pC++;\
			*pA OP aux**pC++;	pA-=2;\
		}while(jt);\
		pB+=3;\
		pC-=b*3;\
	}
#define mmul_1n_plusB6_333_open(TypeR,pA,OP,pB,pC) mmul_1n_plusB6_aB3_open(TypeR,pA,OP,pB,pC,3,3)
#define mmul_1n_plusB6_633_open(TypeR,pA,OP,pB,pC) mmul_1n_plusB6_aB3_open(TypeR,pA,OP,pB,pC,6,3)

//B has extra three not multiplied
#define mmul_nn_plusB6_AB3_open(TypeR,pA,OP,pB,pC,a,b) \
	for(cint it=b;it;pC+=3){ it--;\
		cint jt=a;\
		do{ jt--;\
			TypeR aux=*pB++;\
			*pA++ OP aux**pC++;\
			*pA++ OP aux**pC++;\
			*pA++ OP aux**pC;	pC-=2;\
		}while(jt);\
		pB+=3;\
		pA-=a*3;\
	}
#define mmul_nn_plusB6_333_open(TypeR,pA,OP,pB,pC) mmul_nn_plusB6_AB3_open(TypeR,pA,OP,pB,pC,3,3)
#define mmul_nn_plusB6_363_open(TypeR,pA,OP,pB,pC) mmul_nn_plusB6_AB3_open(TypeR,pA,OP,pB,pC,3,6)

void ATinvsim3_fl(float* N);
void ATinvsim3_dbl(double* N);

//#define invsim_3(N) _Generic(*(N), float: invsim_3_fl, double: invsim_3_dbl)(N)
//#define invsim_6(N) ATinvsim(N,6)
	#define ATinvsim6_fl(N) ATinvsim_fl(N,6)
	#define ATinvsim6_dbl(N) ATinvsim_dbl(N,6)

sinline void depura_matrizsim3_fl(float N[]){
	if(N[1]*N[1]<N[0]*N[4]/16384.F) N[1]=0;
	if(N[2]*N[2]<N[0]*N[8]/16384.F) N[2]=0;
	if(N[5]*N[5]<N[4]*N[8]/16384.F) N[5]=0;
	N[3]=N[1];	N[6]=N[2];	N[7]=N[5];
}
