#pragma once
#include "COMPILER_resolve.h"
#if SYSTEM_ID!=0
#include mergestring(ATfilenames_,SYSTEM.h)
#endif

/******---------        ENCODING OF FILE NAMES        ---------******/

/*The preferred encoding for file names. When this library needs to transform a char8_t
file name to char16_t or vice-versa (in ATfileinput and ATfileoutput) it blindly decodes
a utf-8 char into a 16-bit char and vice-versa. If a utf-8 char represents a char above 2^16
it will substitute for it a default char.*/
#define FILE_ENCODING_BIT8 1
#define FILE_ENCODING_BIT16 2
#ifndef FILE_PREFERRED_ENCODING
	#define FILE_PREFERRED_ENCODING FILE_ENCODING_BIT8
#endif

#include <uchar.h>
#if FILE_PREFERRED_ENCODING==FILE_ENCODING_BIT8
	typedef char charmain_t; //For the main function
	typedef char8_t charfile_t;
	#define FILENAME_PREFIX_U(s) u8##s
#else
	typedef char16_t charmain_t;
	typedef char16_t charfile_t;
	#define FILENAME_PREFIX_U(s) u##s
#endif
//Users will define a shorter name. E.g., #define U FILENAME_PREFIX_U

//Whehter file names represented as char8_t[] are in UTF-8 or not
#ifndef FILE8BITS_ARE_UTF8
#if FILE_PREFERRED_ENCODING==FILE_ENCODING_BIT8
	#define FILE8BITS_ARE_UTF8 1
#else
	#define FILE8BITS_ARE_UTF8 0
#endif
#endif
