#if !defined(AT_FILEOUTPUT_ALL) && !(defined(ATCRT_TYPES_ONLY) && defined(AT_FILEOUTPUT_TYPES))
//AT_FILEOUTPUT_TYPES defined at the end of the file
//AT_FILEOUTPUT_ALL will be defined if !defined(ATCRT_TYPES_ONLY)

#include "ATsystem.h"
#include <uchar.h>
/*The field id in Buffer_bo and Bufferto8 is for knowing to which physical file the buffer refers.
If it has the value ID_NOFILE the buffer is not associated with any file.
The return values for the functions that open the buffers are:*/
// 0: everything right
#define AT_NOMEM -2	//out of memory
#define ATFILEO_OPEN_UNKNOWN 1		//none of the following
#define ATFILEO_OPEN_BADPATH 2		//invalid path
#define ATFILEO_OPEN_NOMORE 3			//cannot open more files
#define ATFILEO_OPEN_NOTALLOWED 4	//no permission for writing that file

#define ATFILEO_OPEN__MAX 4			//Maximum value of the above error codes

//If the returned value is not zero the functions close the external file in case it was opened and leave buf->id set to ID_NOFILE.

//If the value of error_code is positive it will be greater than ATFILEO_OPEN__MAX
#define ATFILEO_ERROR_OTHER ATFILEO_OPEN__MAX+1
#define ATFILEO_ERROR_NOSPACE ATFILEO_OPEN__MAX+2


/** OUTPUT OF BINARY FILES **/

#ifndef AT_FILEOUTPUT_TYPES

typedef struct{
	uintptr_t id;
	u8int endian;	//File's intended endianness
	int error_code;	//Se comprueba antes de cada flush y se asigna justo después.
	uint* base;
	uint *top;
	uint *ptr;
} Buffer_bo;

#endif

#ifndef ATCRT_TYPES_ONLY

#include "ATbytes.h"
#include "ATfunctions.h"
#include "ATiflike.h"
#include "AT_filenames.h"

#ifdef __cplusplus
extern "C"{
#endif
/* Endianness is the one the file will have when written to distk. It must be one of the
values ATFILE_ENDIAN_... The bowrite_... and boput_... functions take care of the change
needed in case the machine's endianness is not the one the file will have. That is, the
pieces of data should be passed to those functions as they are in memory. */
int boopen16(Buffer_bo *buf, const char16_t* fichero, u8int endianness);
int boopen8(Buffer_bo *buf, const char8_t* fichero, u8int endianness);
int boopen_utf8(Buffer_bo *buf, const char8_t* fichero, u8int endianness);
#if FILE8BITS_ARE_UTF8
#define boopen_utf8(buf,fichero,endianness) boopen8(buf,fichero,endianness)
#endif

void boclose(Buffer_bo *buf);
void bo_immediateclose(Buffer_bo *buf);
void bo_internalflush(Buffer_bo *buf);
void bowrite_umints(Buffer_bo *buf,umint* array,uint n);
void bowrite_uints(Buffer_bo *buf,uint* array,uint n);
#ifdef TWO_COMP
#define bowrite_ssints(buf,array,n) bowrite_uints(buf,(uint*)(array),n)
#else
void bowrite_ssints(Buffer_bo *buf,ssint* array,uint n);
#endif
void bowrite_strings(Buffer_bo *buf,char8_t** cs,uint n);
#ifdef __cplusplus
}
#endif

/*The files must be little endian. The correction for big endian processors is done
at the time of writing to the buffer because it depends on the width of the data fields
being written. Therefore, when flushig the contents from the buffer to the file
the bytes must be written in the order they are in the buffer*/
#define boflush(buf) bo_internalflush(buf), (buf)->ptr=(buf)->base
#define bo_checkflush(buf) ifunlike((buf)->ptr==(buf)->top){boflush(buf);}
#define fwrite_uints(file_id,array,n) fwrite(array,usizeof(uint),n,(FILE*)(file_id))

//the values mut be unsigned. The piece of data comes in the endianness of the machine and must be
//copyied according to the output file endianness
#define do_boput_32(buf,x) do{	if((buf)->endian==ATBYTES_LITTLE_ENDIAN) *(buf)->ptr=littleend_u4___u4(x);\
										else if((buf)->endian==ATBYTES_BIG_ENDIAN) *(buf)->ptr=bigend_u4___u4(x);\
										else *(buf)->ptr=uint___u4(x);\
									(buf)->ptr++;}while(0)

#define do_boput_1616(buf,p32,p10) do{	if((buf)->endian==ATBYTES_LITTLE_ENDIAN) *(buf)->ptr=littleend_u4___u22(p32,p10);\
													else if((buf)->endian==ATBYTES_BIG_ENDIAN) *(buf)->ptr=bigend_u4___u22(p32,p10);\
													else *(buf)->ptr=uint___u22(p32,p10);\
											(buf)->ptr++;}while(0)

#define do_boput_1688(buf,p32,p1,p0) do{	if((buf)->endian==ATBYTES_LITTLE_ENDIAN) *(buf)->ptr=littleend_u4___u211(p32,p1,p0);\
														else if((buf)->endian==ATBYTES_BIG_ENDIAN) *(buf)->ptr=bigend_u4___u211(p32,p1,p0);\
														else *(buf)->ptr=uint___u211(p32,p1,p0);\
												(buf)->ptr++;}while(0)

#define do_boput_8816(buf,p3,p2,p10) do{	if((buf)->endian==ATBYTES_LITTLE_ENDIAN) *(buf)->ptr=littleend_u4___u112(p3,p2,p10);\
														else if((buf)->endian==ATBYTES_BIG_ENDIAN) *(buf)->ptr=bigend_u4___u112(p3,p2,p10);\
														else *(buf)->ptr=uint___u112(p3,p2,p10);\
												(buf)->ptr++;}while(0)

#define do_boput_8888(buf,p3,p2,p1,p0) *(buf)->ptr++=uint___u1111(p3,p2,p1,p0)

#define boput_32(buf,x) do{bo_checkflush(buf) do_boput_32(buf,x);}while(0)
#define boput_1616(buf,p32,p10) do{bo_checkflush(buf) do_boput_1616(buf,p32,p10);}while(0)
#define boput_1688(buf,p32,p1,p0) do{bo_checkflush(buf) do_boput_1688(buf,p32,p1,p0);}while(0)
#define boput_8816(buf,p3,p2,p10) do{bo_checkflush(buf) do_boput_8816(buf,p3,p2,p10);}while(0)
#define boput_8888(buf,p3,p2,p1,p0) do{bo_checkflush(buf) do_boput_8888(buf,p3,p2,p1,p0);}while(0)

#define bowrite_chars(buf,array,n) bowrite_umints(buf,(umint*)array,n)
#define bowrite_string(buf,cs) {uint n=strlen8(cs)+1; bowrite_umints(buf,(umint*)(cs),n);}
#define bowrite_wstring(buf,cs) {uint n=(strlen16(cs)+1)*usizeof(char16_t); bowrite_umints(buf,(umint*)(cs),n);}

//#if IEEE_FLOATS
#if 1
#define boput_SINGLE(buf,flptr){IO_SINGLE bo_n=*(IO_SINGLE*)flptr; boput_32(buf,bo_n);}
#define boput_DOUBLE(buf,dblptr){uint bo_n=*(uint*)flptr; boput_32(buf,bo_n); bo_n=*((uint*)flptr+1); boput_32(buf,bo_n);}
#define bowrite_SINGLEs(buf,array,n) bowrite_uints(buf,(uint*)(array),n)
#define bowrite_DOUBLEs(buf,array,n) bowrite_uints(buf,(uint*)(array),n<<1)
#endif
//else, must be converted to IEEE float, with the final version of one bit removed from the mantissa and passed to the exponent (I'd like the older version)

#endif //ATCRT_TYPES_ONLY


/** OUTPUT OF TEXT FILES **/

#ifndef AT_FILEOUTPUT_TYPES

#define ATFILEO_TYPE_UNSET ((u8int)-1)
#define ATFILEO_TYPE_CHAR8 1
#define ATFILEO_TYPE_CHAR16 2
//Output of 8-bit and 16-bit text files
#define Bufferto_BASE(Type) \
	uintptr_t id;\
	u8int endian;	/*File's intended endianness, for cha16. But it is not yet taken into account*/\
	int error_code;\
	Type* base;\
	Type *top;		/*The allocated memory will exceed top*/\
	Type *ptr;\
	Type *backPtr;	/*Point to the top of the allocated; for writing backwards. Actually, there is still one more uint above, set to 0.*/\
	uint flushedchars;	/*need not be accessible by the user*/\
	uint flt_flags;\
	struct{\
		s8int absol;	/*number of fixed decimal places, for absolute mode. = -log10(last significant digit)*/\
		u8int signi;	/*number of significant digits, for relative mode*/\
	} prec;\
	Type fillchar;\
	Type maschar;	/*normally '\0', '+' or ' ' */
	//Véase abajo la descripción de flt_flags

typedef struct str_Bufferto8{
	Bufferto_BASE(char8_t)
} Bufferto8, BuffertoGeneric;
typedef struct str_Bufferto16{
	Bufferto_BASE(char16_t)
} Bufferto16;

//Con poca memoria reservada, para formatear números
typedef Bufferto8 ATFormatter;

#endif //AT_FILEOUTPUT_TYPES

#ifndef ATCRT_TYPES_ONLY

/*Si fichero es NULL no hay ningún fichero asociado pero el Buffer se puede usar.
En ese caso, si se produce algún intento de escritura al fichero se pondrá
error_code a ATFILEO_ERROR_NOSPACE (not enough space left).
SetupFormatter es como pasar fichero=NULL, solo que el buffer reservado es
mucho más pequeño (256 uints=1KB)*/
#ifdef __cplusplus
extern "C"{
#endif
int toopen8(Bufferto8 *buf, const char8_t* fichero);
int toopen_mixed(Bufferto8 *buf, const char16_t* fichero);
int toopen16(Bufferto16 *buf, const char16_t* fichero);
int toopen_utf8(Bufferto8 *buf, const char8_t* fichero);
#if FILE8BITS_ARE_UTF8
#define toopen_utf8(buf,fichero) toopen8(buf,fichero)
#endif
int SetupFormatter(Bufferto8 *buf);

void toclose_generic(BuffertoGeneric *buf);
void to_immediateclose(BuffertoGeneric *buf);
void to_internalflush(BuffertoGeneric *buf);

//The files must be little endian. The correction for big endian processors is done at the time of writing to the buffer.
//Ignores the error code and proceeds
#define toclose(buf) toclose_generic((BuffertoGeneric*)buf)
#define toflush(buf) do{to_internalflush((BuffertoGeneric*)buf); (buf)->flushedchars+=(pdif)((buf)->ptr-(buf)->base); (buf)->ptr=(buf)->base;}while(0)
#define to_checkflush(buf) ifunlike((buf)->ptr>=(buf)->top){toflush(buf);}
#define to_writtenchars(buf) ((buf)->flushedchars + (pdif)((buf)->ptr-(buf)->base))
#define to_reset(buf) (buf)->ptr=(buf)->base, (buf)->error_code=0
#define towrite_BOM_utf8(buf) do{*(buf).ptr++=0xEF; *(buf).ptr++=0xBB; *(buf).ptr++=0xBF;}while(0)

//These work for both 8bit and 16bit Bufferto's
#define do_toput_char(buf,x) *(buf)->ptr++=x
#define toput_char(buf,x) do{to_checkflush(buf) do_toput_char((buf),x);}while(0)
//write the UTF-8 representation of c
#define towrite8_utf8char(buf,c) do{to_checkflush(buf) toput_utf8char(buf,c);}while(0)

void towrite8_string(Bufferto8 *buf,const char8_t *s);
void towrite8_string_s(Bufferto8 *buf,const char8_t *s);	//s is ' '-terminated
void towrite8_string_s0(Bufferto8 *buf,const char8_t *s); //s is ' '- or '\0'-terminated
void towrite8_string_t(Bufferto8 *buf,const char8_t *s);	//s is '\t'-terminated
void towrite8_string_st(Bufferto8 *buf,const char8_t *s); //s is ' '-, or '\t'-terminated
void towrite8_string_n(Bufferto8 *buf,const char8_t *s);	//s is '\n'-terminated
void towrite8_string_n0(Bufferto8 *buf,const char8_t *s);	//s is '\n'- or  '\0'-terminated
void towrite8_string_b(Bufferto8 *buf,const char8_t *s);	//s is terminated by any of ' ', '\t' or '\n'
void towrite8_string_b0(Bufferto8 *buf,const char8_t *s); //s is terminated by any of '\0', ' ', '\t' or '\n'
void towrite8_stringl(Bufferto8 *buf,const char8_t *s,char8_t nl); //nl is typically '\n', but it may be any character
void towrite8_left_string(Bufferto8 *buf,const char8_t* s, u8int width);
void towrite8_aligned_string(Bufferto8 *buf,const char8_t* s,u8int width);
void toput_utf8char(Bufferto8 *buf,const char16_t c);
//Only the lower byte is written for every char16_t
void towrite8_string16_charred(Bufferto8 *buf,const char16_t *s);
//Each char16_t is converted to its UTF-8 representation
void towrite8_string16_utf8(Bufferto8 *buf,const char16_t *s);
//Each char8_t >= 0x80 is converted to its UTF-8 representation
void towrite8_string8_utf8(Bufferto8 *buf,const char8_t *s);
//Write an unsigned integer
void towrite8_uint(Bufferto8 *buf,uint x);
void towrite8_left_uint(Bufferto8 *buf, uint x,u8int width);
void towrite8_aligned_uint(Bufferto8 *buf, uint x,u8int width);
//Write a signed integer
static inline void towrite8_ssint(Bufferto8 *buf,ssint x){if(x<0){toput_char(buf,'-'); x=-x;} towrite8_uint(buf,x);}
static inline void towrite8_left_ssint(Bufferto8 *buf,ssint x, u8int width){
	if(x<0){toput_char(buf,'-'); x=-x; iflike(width>0) width--;}
	towrite8_left_uint(buf,x,width);
}
void towrite8_aligned_ssint(Bufferto8 *buf, ssint x,u8int width);
//Write an unsigned integer, base hex
void towrite8_hex(Bufferto8 *buf,uint x);
void towrite8_left_hex(Bufferto8 *buf, uint x,u8int width);
void towrite8_aligned_hex(Bufferto8 *buf, uint x,u8int width);
//Write a floating point number
void towrite8_double(Bufferto8 *buf, double fl);
void towrite8_left_double(Bufferto8 *buf, double fl,u8int width);
void towrite8_aligned_double(Bufferto8 *buf, double fl,u8int width);
#define towrite8_float towrite8_double
#define towrite8_left_float towrite8_left_double
#define towrite8_aligned_float towrite8_aligned_double
void towrite8_many_strings(Bufferto8 *buf, const char8_t *s1,...);
//tipos: 'c', 's', 'S', 'w', 'u', 'i', 'f': char, string, stn0-ended string, string16, unsigned int, int, double. They consume the next parameter
//0 marks the end; any other character as tipo prints itself without consuming the next parameter,
//The string16 will be written as utf8
void towrite8(Bufferto8 *buf, int tipo0,...);
/*Como printf, pero lo que puede seguir a un % es solamente % o uno de los caracteres siguientes:
'c', 's', 'S<x>', 'w', 'u', 'i', 'f': char, string, <other>-ended string, string16, unsigned int, int, double.
The string16 will be written as utf8
El carácter que sigue a la indicación %S indica el carácter o caracteres que tereminan el string, y se interpreta como sigue:
's': un espacio: ' '
'S': Espacio o '\0'.
't': una tabulación (horizontal): '\t'
'T': Espacio o tabulación.
'n': final de línea: '\n'
'N': final de línea o '\0'
b: Un blanco, cualquiera de ' ', '\t', '\n'
B: Un blanco o un '\0'
*/
void towritef8(Bufferto8 *buf, const char8_t *s,...);
//
void towrite16_string(Bufferto16 *buf,const char16_t *s);
void towrite16_stringl(Bufferto16 *buf,const char16_t *s,char16_t nl);
void towrite16_string_s(Bufferto16 *buf,const char16_t *s);	//s is ' '-terminated
void towrite16_string_s0(Bufferto16 *buf,const char16_t *s);	//s is ' '- or '\0'-terminated
void towrite16_string_t(Bufferto16 *buf,const char16_t *s);	//s is '\t'-terminated
void towrite16_string_st(Bufferto16 *buf,const char16_t *s);	//s is ' '-, or '\t'-terminated
void towrite16_string_n(Bufferto16 *buf,const char16_t *s);	//s is '\n'-terminated
void towrite16_string_n0(Bufferto16 *buf,const char16_t *s);	//s is '\n'- or '\0'-terminated
void towrite16_string_b(Bufferto16 *buf,const char16_t *s);	//s is terminated by any of ' ', '\t' or '\n'
void towrite16_string_b0(Bufferto16 *buf,const char16_t *s); //s is terminated by any of '\0', ' ', '\t' or '\n'
void towrite16_left_string(Bufferto16 *buf,const char16_t* s, u8int width);
void towrite16_aligned_string(Bufferto16 *buf,const char16_t* s,u8int width);
//Write an unsigned integer
void towrite16_uint(Bufferto16 *buf,uint x);
void towrite16_left_uint(Bufferto16 *buf, uint x,u8int width);
void towrite16_aligned_uint(Bufferto16 *buf, uint x,u8int width);
//Write a signed integer
static inline void towrite16_ssint(Bufferto16 *buf,ssint x){if(x<0){toput_char(buf,'-'); x=-x;} towrite16_uint(buf,x);}
static inline void towrite16_left_ssint(Bufferto16 *buf,ssint x, u8int width){
	if(x<0){toput_char(buf,'-'); x=-x; iflike(width>0) width--;}
	towrite16_left_uint(buf,x,width);
}
void towrite16_aligned_ssint(Bufferto16 *buf, ssint x,u8int width);
//Write an unsigned integer, base hex
void towrite16_hex(Bufferto16 *buf,uint x);
void towrite16_left_hex(Bufferto16 *buf, uint x,u8int width);
void towrite16_aligned_hex(Bufferto16 *buf, uint x,u8int width);
//Write a floating point number
void towrite16_double(Bufferto16 *buf, double fl);
void towrite16_left_double(Bufferto16 *buf, double fl,u8int width);
void towrite16_aligned_double(Bufferto16 *buf, double fl,u8int width);
#define towrite16_float towrite16_double
#define towrite16_left_float towrite16_left_double
#define towrite16_aligned_float towrite16_aligned_double
void towrite16_many_strings(Bufferto16 *buf, const char16_t *s1,...);
/*tipos: 'c', 's', 'S', 'u', 'i', 'f': char, string16, stn0-ended string16, unsigned int, int, double.
The string16 will be written as utf8*/
void towrite16(Bufferto16 *buf, int tipo0,...);
/*tipos: 'c', 's', 'S<x>', 'u', 'i', 'f': char, string16, <other>-ended string16, unsigned int, int, double.
El carácter que sigue a la indicación %S indica el carácter o caracteres que tereminan el string, y se interpreta como sigue:
's': un espacio: ' '
'S': Espacio o '\0'.
't': una tabulación (horizontal): '\t'
'T': Espacio o tabulación.
'n': final de línea: '\n'
'N': final de línea o '\0'
b: Un blanco, es decir, cualquiera de ' ', '\t', '\n'
B: Un blanco o un '\0'
*/
void towritef16(Bufferto16 *buf, const char16_t *s,...);
#ifdef __cplusplus
}
#endif

#define towrite_utf8char towrite8_utf8char
#define towrite_string16_charred towrite8_string16_charred
#define towrite_string16_utf8 towrite8_string16_utf8
#define towrite_string8_utf8 towrite8_string8_utf8

#define towrite_float towrite_double
#define towrite_left_float towrite_left_double
#define towrite_aligned_float towrite_aligned_double

/*flt_flags:
	1:	0: no_limpiar. Se escriben los ceros a la derecha
		1: limpiar. No se escriben los ceros a la derecha
	2:	0: no_scientific. No se permite notación científica
		1: scientific. Se permite. Sólo se aplica en modo relative.
	4:	0: absolute. El valor de precisión se refiere a número de decimales.
		1: relative. El valor de precisión se refiere a número de cifras significativas
	8:  1: avoid_zero: En caso de estar en modo 'absolute' y prec.absol<0,
		  no escribir un cero si |f|>=0.5.

	scientific sólo se aplica en modo relative para no añadir código al caso absolute
	que no se va a ejecutar casi nunca. Si se quiere que prec marque simplemente
	el valor de la ultima cifra que se muestre, y se escriba con notación científica
	si (p.ej.) x<0.001 simplemente hay que escribir esto mismo en el código. Es muy
	fácil escribir una pequeña función que decida según lo que el usuario quiera.
*/
#define isbuf_limpio(buf) (((buf)->flt_flags&1)!=0)
#define isbuf_scientific(buf) (((buf)->flt_flags&2)!=0)
#define isbuf_absolute(buf) (((buf)->flt_flags&4)==0)
#define isbuf_relative(buf) (((buf)->flt_flags&4)!=0)
#define isbuf_avoidzero(buf) (((buf)->flt_flags&8)!=0)
//
#define setbuf_limpio(buf) (buf)->flt_flags|=1
#define setbuf_nolimpio(buf) (buf)->flt_flags&=~1U
#define setbuf_scientific(buf) (buf)->flt_flags|=2
#define setbuf_noscientific(buf) (buf)->flt_flags&=~2U
#define setbuf_relative(buf) (buf)->flt_flags|=4
#define setbuf_absolute(buf) (buf)->flt_flags&=~4U
#define setbuf_avoidzero(buf) (buf)->flt_flags|=8
#define setbuf_noavoidzero(buf) (buf)->flt_flags&=~8U
#define setbuf_relativep(buf,d) setbuf_relative(buf), (buf)->prec.signi=d
#define setbuf_absolutep(buf,d) setbuf_absolute(buf), (buf)->prec.absol=d
//
#define buf_fillchar(buf) ((buf)->fillchar)
#define setbuf_fillchar(buf,c) (buf)->fillchar=(c)
#define checkbuf_prec(buf) do{\
	ifunlike(buf->prec.signi>18) buf->prec.signi=18;\
	ifunlike(buf->prec.absol>18) buf->prec.absol=18;\
	else ifunlike(buf->prec.absol<-6) buf->prec.absol=-6;\
} while(0)

//Definiciones para nombres de funciones genéricos, que se expanden a las variantes 8 o 16 según el caso.
//Si en un fichero de código se va a emplear siempre el mismo tipo; es decir, siempre Bufferto8 o Bufferto16,
//una solución más limpia tras el preprocesado es incluir el fichero definesBufferto8.h o definesBufferto6.h

#ifndef __cplusplus

#undef towrite_string
#undef towrite_stringl
#undef towrite_left_string
#undef towrite_aligned_string
#undef towrite_string_s
#undef towrite_string_t
#undef towrite_string_st
#undef towrite_string_n
#undef towrite_string_b
#undef towrite_string_b0
#undef towrite_uint
#undef towrite_left_uint
#undef towrite_aligned_uint
#undef towrite_ssint
#undef towrite_left_ssint
#undef towrite_aligned_ssint
#undef towrite_ssint
#undef towrite_hex
#undef towrite_left_hex
#undef towrite_aligned_hex
#undef towrite_double
#undef towrite_left_double
#undef towrite_aligned_double
#undef towrite_many_strings
#undef towrite
#undef towritef

#ifdef GENERIC_NOT_IMPLEMENTED

#define towrite_string(buf,s)				sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_string((Bufferto8*)buf,(const char8_t*)s) : towrite16_string((Bufferto16*)buf,(const char16_t*)s)
#define towrite_stringl(buf,s,nl)			sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_stringl((Bufferto8*)buf,(const char8_t*)s,nl) : towrite16_stringl((Bufferto16*)buf,(const char16_t*)s,nl)
#define towrite_left_string(buf,s,w)		sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_left_string((Bufferto8*)buf,(const char8_t*)s,w) : towrite16_left_string((Bufferto16*)buf,(const char16_t*)s,w)
#define towrite_aligned_string(buf,s,w)	sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_aligned_string((Bufferto8*)buf,(const char8_t*)s,w) : towrite16_aligned_string((Bufferto16*)buf,(const char16_t*)s,w)
#define towrite_string_s(buf,s)				sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_string_s((Bufferto8*)buf,(const char8_t*)s) : towrite16_string_s((Bufferto16*)buf,(const char16_t*)s)
#define towrite_string_t(buf,s)				sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_string_t((Bufferto8*)buf,(const char8_t*)s) : towrite16_string_t((Bufferto16*)buf,(const char16_t*)s)
#define towrite_string_st(buf,s)			sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_string_st((Bufferto8*)buf,(const char8_t*)s) : towrite16_string_st((Bufferto16*)buf,(const char16_t*)s)
#define towrite_string_n(buf,s)			sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_string_n((Bufferto8*)buf,(const char8_t*)s) : towrite16_string_n((Bufferto16*)buf,(const char16_t*)s)
#define towrite_string_b(buf,s)				sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_string_b((Bufferto8*)buf,(const char8_t*)s) : towrite16_string_b((Bufferto16*)buf,(const char16_t*)s)
#define towrite_string_b0(buf,s)			sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_string_b0((Bufferto8*)buf,(const char8_t*)s) : towrite16_string_b0((Bufferto16*)buf,(const char16_t*)s)
#define towrite_uint(buf,x)					sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_uint((Bufferto8*)buf,x) : towrite16_uint((Bufferto16*)buf,x)
#define towrite_left_uint(buf,x,w)			sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_left_uint((Bufferto8*)buf,x,w) : towrite16_left_uint((Bufferto16*)buf,x,w)
#define towrite_aligned_uint(buf,x,w)	sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_aligned_uint((Bufferto8*)buf,x,w) : towrite16_aligned_uint((Bufferto16*)buf,x,w)
#define towrite_ssint(buf,x)					sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_ssint((Bufferto8*)buf,x) : towrite16_ssint((Bufferto16*)buf,x)
#define towrite_left_ssint(buf,x,w)		sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_left_ssint((Bufferto8*)buf,x,w) : towrite16_left_ssint((Bufferto16*)buf,x,w)
#define towrite_aligned_ssint(buf,x,w)	sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_aligned_ssint((Bufferto8*)buf,x,w) : towrite16_aligned_ssint((Bufferto16*)buf,x,w)
#define towrite_hex(buf,x)					sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_hex((Bufferto8*)buf,x) : towrite16_hex((Bufferto16*)buf,x)
#define towrite_left_hex(buf,x,w)			sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_left_hex((Bufferto8*)buf,x,w) : towrite16_left_hex((Bufferto16*)buf,x,w)
#define towrite_aligned_hex(buf,x,w)		sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_aligned_hex((Bufferto8*)buf,x,w) : towrite16_aligned_hex((Bufferto16*)buf,x,w)
#define towrite_double(buf,fl)				sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_double((Bufferto8*)buf,fl) : towrite16_double((Bufferto16*)buf,fl)
#define towrite_left_double(buf,fl,w)		sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_left_double((Bufferto8*)buf,fl,w) : towrite16_left_double((Bufferto16*)buf,fl,w)
#define towrite_aligned_double(buf,fl,w) sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_aligned_double((Bufferto8*)buf,fl,w) : towrite16_aligned_double((Bufferto16*)buf,fl,w)
#define towrite_many_strings(buf,s1,...)	sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8_many_strings((Bufferto8*)buf,(const char8_t*)s1,__VA_ARGS__) : towrite16_many_strings((Bufferto16*)buf,(const char16_t*)s1,__VA_ARGS__)
#define towrite(buf,tipo0,...)				sizeof(*(buf)->ptr)==sizeof(char8_t) ? towrite8((Bufferto8*)buf,tipo0,__VA_ARGS__) : towrite16((Bufferto16*)buf,tipo0,__VA_ARGS__)
#define towritef(buf,s,...)						sizeof(*(buf)->ptr)==sizeof(char8_t) ? towritef8((Bufferto8*)buf,(const char8_t*)s,__VA_ARGS__) : towritef16((Bufferto16*)buf,(const char16_t*)s,__VA_ARGS__)

#else

#define towrite_string(buf,s)						_Generic((buf)->ptr, char8_t*: towrite8_string, char16_t*: towrite16_string)(buf,s)
#define towrite_stringl(buf,s,nl)					_Generic((buf)->ptr, char8_t*: towrite8_stringl, char16_t*: towrite16_stringl)(buf,s,nl)
#define towrite_left_string(buf,s,width)			_Generic((buf)->ptr, char8_t*: towrite8_left_string, char16_t*: towrite16_left_string)(buf,s,width)
#define towrite_aligned_string(buf,s,width)	_Generic((buf)->ptr, char8_t*: towrite8_aligned_string, char16_t*: towrite16_aligned_string)(buf,s,width)
#define towrite_string_s(buf,s)						_Generic((buf)->ptr, char8_t*: towrite8_string_s, char16_t*: towrite16_string_s)(buf,s)
#define towrite_string_t(buf,s)						_Generic((buf)->ptr, char8_t*: towrite8_string_t, char16_t*: towrite16_string_t)(buf,s)
#define towrite_string_st(buf,s)					_Generic((buf)->ptr, char8_t*: towrite8_string_st, char16_t*: towrite16_string_st)(buf,s)
#define towrite_string_n(buf,s)					_Generic((buf)->ptr, char8_t*: towrite8_string_n, char16_t*: towrite16_string_n)(buf,s)
#define towrite_string_b(buf,s)						_Generic((buf)->ptr, char8_t*: towrite8_string_b, char16_t*: towrite16_string_b)(buf,s)
#define towrite_string_b0(buf,s)					_Generic((buf)->ptr, char8_t*: towrite8_string_b0, char16_t*: towrite16_string_b0)(buf,s)
#define towrite_uint(buf,x)							_Generic((buf)->ptr, char8_t*: towrite8_uint, char16_t*: towrite16_uint)(buf,x)
#define towrite_left_uint(buf,x,width)			_Generic((buf)->ptr, char8_t*: towrite8_left_uint, char16_t*: towrite16_left_uint)(buf,x,width)
#define towrite_aligned_uint(buf,x,width)		_Generic((buf)->ptr, char8_t*: towrite8_aligned_uint, char16_t*: towrite16_aligned_uint)(buf,x,width)
#define towrite_ssint(buf,x)							_Generic((buf)->ptr, char8_t*: towrite8_ssint, char16_t*: towrite16_ssint)(buf,x)
#define towrite_left_ssint(buf,x,width)			_Generic((buf)->ptr, char8_t*: towrite8_left_ssint, char16_t*: towrite16_left_ssint)(buf,x,width)
#define towrite_aligned_ssint(buf,x,width)		_Generic((buf)->ptr, char8_t*: towrite8_aligned_ssint, char16_t*: towrite16_aligned_ssint)(buf,x,width)
#define towrite_hex(buf,x)							_Generic((buf)->ptr, char8_t*: towrite8_hex, char16_t*: towrite16_hex)(buf,x)
#define towrite_left_hex(buf,x,width)			_Generic((buf)->ptr, char8_t*: towrite8_left_hex, char16_t*: towrite16_left_hex)(buf,x,width)
#define towrite_aligned_hex(buf,x,width)		_Generic((buf)->ptr, char8_t*: towrite8_aligned_hex, char16_t*: towrite16_aligned_hex)(buf,x,width)
#define towrite_double(buf,fl		)				_Generic((buf)->ptr, char8_t*: towrite8_double, char16_t*: towrite16_double)(buf,fl)
#define towrite_left_double(buf,fl,width)		_Generic((buf)->ptr, char8_t*: towrite8_left_double, char16_t*: towrite16_left_double)(buf,fl,width)
#define towrite_aligned_double(buf,fl,width)	_Generic((buf)->ptr, char8_t*: towrite8_aligned_double, char16_t*: towrite16_aligned_double)(buf,fl,width)
#define towrite_many_strings(buf,s1,...)			_Generic((buf)->ptr, char8_t*: towrite8_many_strings, char16_t*: towrite16_many_strings)(buf,s1,__VA_ARGS__)
#define towrite(buf,tipo0,...)						_Generic((buf)->ptr, char8_t*: towrite8, char16_t*: towrite16)(buf,tipo0,__VA_ARGS__)
#define towritef(buf,s,...)								_Generic((buf)->ptr, char8_t*: towritef8, char16_t*: towritef16)(buf,s,__VA_ARGS__)
#endif

#else //__cplusplus

inline void towrite_string(Bufferto8 *buf, const char8_t* s){return towrite8_string(buf,s);}
inline void towrite_stringl(Bufferto8 *buf, const char8_t* s, char8_t nl){return towrite8_stringl(buf,s,nl);}
inline void towrite_left_string(Bufferto8 *buf, const char8_t* s, u8int width){return towrite8_left_string(buf,s,width);}
inline void towrite_aligned_string(Bufferto8 *buf, const char8_t* s, u8int width){return towrite8_aligned_string(buf,s,width);}
inline void towrite_string_s(Bufferto8 *buf, const char8_t* s){return towrite8_string_s(buf,s);}
inline void towrite_string_t(Bufferto8 *buf, const char8_t* s){return towrite8_string_t(buf,s);}
inline void towrite_string_st(Bufferto8 *buf, const char8_t* s){return towrite8_string_st(buf,s);}
inline void towrite_string_n(Bufferto8 *buf, const char8_t* s){return towrite8_string_n(buf,s);}
inline void towrite_string_b(Bufferto8 *buf, const char8_t* s){return towrite8_string_b(buf,s);}
inline void towrite_string_b0(Bufferto8 *buf, const char8_t* s){return towrite8_string_b0(buf,s);}
inline void towrite_uint(Bufferto8 *buf, uint n){return towrite8_uint(buf,n);}
inline void towrite_left_uint(Bufferto8 *buf, uint n, u8int width){return towrite8_left_uint(buf,n,width);}
inline void towrite_aligned_uint(Bufferto8 *buf, uint n, u8int width){return towrite8_aligned_uint(buf,n,width);}
inline void towrite_ssint(Bufferto8 *buf, ssint n){return towrite8_ssint(buf,n);}
inline void towrite_left_ssint(Bufferto8 *buf, ssint n, u8int width){return towrite8_left_ssint(buf,n,width);}
inline void towrite_aligned_ssint(Bufferto8 *buf, ssint n, u8int width){return towrite8_aligned_ssint(buf,n,width);}
inline void towrite_hex(Bufferto8 *buf, uint n){return towrite8_hex(buf,n);}
inline void towrite_left_hex(Bufferto8 *buf, uint n, u8int width){return towrite8_left_hex(buf,n,width);}
inline void towrite_aligned_hex(Bufferto8 *buf, uint n, u8int width){return towrite8_aligned_hex(buf,n,width);}
inline void towrite_double(Bufferto8 *buf, double fl){return towrite8_double(buf,fl);}
inline void towrite_left_double(Bufferto8 *buf, double fl, u8int width){return towrite8_left_double(buf,fl,width);}
inline void towrite_aligned_double(Bufferto8 *buf, double fl, u8int width){return towrite8_aligned_double(buf,fl,width);}

inline void towrite_string(Bufferto16 *buf, const char16_t* s){return towrite16_string(buf,s);}
inline void towrite_stringl(Bufferto16 *buf, const char16_t* s, char16_t nl){return towrite16_stringl(buf,s,nl);}
inline void towrite_left_string(Bufferto16 *buf, const char16_t* s, u8int width){return towrite16_left_string(buf,s,width);}
inline void towrite_aligned_string(Bufferto16 *buf, const char16_t* s, u8int width){return towrite16_aligned_string(buf,s,width);}
inline void towrite_string_s(Bufferto16 *buf, const char16_t* s){return towrite16_string_s(buf,s);}
inline void towrite_string_t(Bufferto16 *buf, const char16_t* s){return towrite16_string_t(buf,s);}
inline void towrite_string_st(Bufferto16 *buf, const char16_t* s){return towrite16_string_st(buf,s);}
inline void towrite_string_n(Bufferto16 *buf, const char16_t* s){return towrite16_string_n(buf,s);}
inline void towrite_string_b(Bufferto16 *buf, const char16_t* s){return towrite16_string_b(buf,s);}
inline void towrite_string_b0(Bufferto16 *buf, const char16_t* s){return towrite16_string_b0(buf,s);}
inline void towrite_uint(Bufferto16 *buf, uint n){return towrite16_uint(buf,n);}
inline void towrite_left_uint(Bufferto16 *buf, uint n, u8int width){return towrite16_left_uint(buf,n,width);}
inline void towrite_aligned_uint(Bufferto16 *buf, uint n, u8int width){return towrite16_aligned_uint(buf,n,width);}
inline void towrite_ssint(Bufferto16 *buf, ssint n){return towrite16_ssint(buf,n);}
inline void towrite_left_ssint(Bufferto16 *buf, ssint n, u8int width){return towrite16_left_ssint(buf,n,width);}
inline void towrite_aligned_ssint(Bufferto16 *buf, ssint n, u8int width){return towrite16_aligned_ssint(buf,n,width);}
inline void towrite_hex(Bufferto16 *buf, uint n){return towrite16_hex(buf,n);}
inline void towrite_left_hex(Bufferto16 *buf, uint n, u8int width){return towrite16_left_hex(buf,n,width);}
inline void towrite_aligned_hex(Bufferto16 *buf, uint n, u8int width){return towrite16_aligned_hex(buf,n,width);}
inline void towrite_double(Bufferto16 *buf, double fl){return towrite16_double(buf,fl);}
inline void towrite_left_double(Bufferto16 *buf, double fl, u8int width){return towrite16_left_double(buf,fl,width);}
inline void towrite_aligned_double(Bufferto16 *buf, double fl, u8int width){return towrite16_aligned_double(buf,fl,width);}

#define towrite_many_strings(buf,s1,...) get_towms_ptr(buf)(buf,s1,__VA_ARGS__)
#define towrite(buf,tipo0,...) get_tow_ptr(buf)(buf,tipo0,__VA_ARGS__)
#define towritef(buf,s,...) get_towf_ptr(buf)(buf,s,__VA_ARGS__)
inline void (*get_towms_ptr(Bufferto8 *_unused(buf))) (Bufferto8*,const char8_t* s1,...){return &towrite8_many_strings;}
inline void (*get_towms_ptr(Bufferto16 *_unused(buf))) (Bufferto16*,const char16_t* s1,...){return &towrite16_many_strings;}
inline void (*get_tow_ptr(Bufferto8 *_unused(buf))) (Bufferto8*,int tipo0,...){return &towrite8;}
inline void (*get_tow_ptr(Bufferto16 *_unused(buf))) (Bufferto16*,int tipo0,...){return &towrite16;}
inline void (*get_towf_ptr(Bufferto8 *_unused(buf))) (Bufferto8*,const char8_t* s,...){return &towritef8;}
inline void (*get_towf_ptr(Bufferto16 *_unused(buf))) (Bufferto16*,const char16_t* s,...){return &towritef16;}

#endif

#define ID_NOFILE ((uintptr_t)NULL)	/*May be redefined*/
#include mergestring(fileoutput_,COMPILER.h)

#endif //ATCRT_TYPES_ONLY


#define AT_FILEOUTPUT_TYPES
#if !defined(ATCRT_TYPES_ONLY)
	#define AT_FILEOUTPUT_ALL
#endif

#endif
