#if !defined(AT_FIXEDPOINT_ALL) && !(defined(ATCRT_TYPES_ONLY) && defined(AT_FIXEDPOINT_TYPES))
//AT_FIXEDPOINT_TYPES defined at the end of the file
//AT_FIXEDPOINT_all will be defined if !defined(ATCRT_TYPES_ONLY)

/*Fixed point types. Small integer types that represent a number between 0 and 1 (typically). If
the type is 8-bits it may hold a value in [0 - 128], in which case the type is uintf7. It may also hold
a value in [0 - 255], in which case it is uintf8, the value being the 1/256-length interval in which
the real number lies. In this case, when the value is operated, the value for the center of the
interval may be chosen, or the lower end, in which case the "1" would be missing, or the upper
end, in which case the "0" would be missing, or 0 -> 0, 255 -> 1 and the interval middle point for
the other values, or some user defined solution.
    The macros below assume that the floating point number being passed to them is already in
the interval [0 - 1]. Multiplication by a power of 2 does not change the mantissa (of a regular
number); therefore, if f<1 prior to multiplication, f<256 will hold after multiplication.
*/

#ifndef AT_FIXEDPOINT_TYPES

typedef uint8m uintf7, uintf8;
typedef uint16m uintf15, uintf16;

#define UINTF7_MIN 0
#define UINTF7_MAX 128
#define UINTF8_MIN 0
#define UINTF8_MAX 255
#define UINTF8_PIECES 256
#define UINTF15_MIN 0
#define UINTF15_MAX 32768
#define UINTF16_MIN 0
#define UINTF16_MAX 65535
#define UINTF16_PIECES 65536

#endif

#ifndef ATCRT_TYPES_ONLY

#ifndef uintf7___f
#define uintf7___f(f) ((uintf7)((f)*128.F))
#define uintf15___f(f) ((uintf15)((f)*32768.F))
#endif
#ifndef uintf8___f
#define uintf8___f(f) ((f)>=1.0F ? (uintf8)255 : (uintf8)((f)*256.F))
#define uintf16___f(f) ((f)>=1.0F ? (uintf16)0xFFFF : (uintf16)((f)*65536.F))
#endif
//Complementarios a 1
#define UINTF7_COMP(f) ((uintf7)(UINTF7_MAX-(f)))
#define UINTF8_COMP(f) ((uintf8)~(f))
#define UINTF15_COMP(f) ((uintf15)(UINTF15_MAX-(f)))
#define UINTF16_COMP(f) ((uintf16)~(f))
//These defines are used for the macros that follow. One unit less is also possible. E. g., UINTF7_HALF 63
#define UINTF7_HALF 64
#define UINTF8_HALF 128
#define UINTF15_HALF 0x4000
#define UINTF16_HALF 0x8000

#ifndef applyu_f7
#define applyu_f7(u,f) (((unsigned int)(u)*(f)+UINTF7_HALF)>>7)
#define applys_f7(s,f) (((int)(s)*(f)+UINTF7_HALF)>>7) //sign-extend
#define applyu_f8mid(u,f) (((unsigned int)(u)*(((f)<<1)|1)+(UINTF8_PIECES+UINTF8_HALF))>>9)
#define applys_f8mid(s,f) (((int)(s)*(((f)<<1)|1)+(UINTF8_PIECES+UINTF8_HALF))>>9) //sign-extended
#define applyu_f8down(u,f) (((unsigned int)(u)*(f)+UINTF8_HALF)>>8)
#define applys_f8down(s,f) (((int)(s)*(f)+UINTF8_HALF)>>8) //sign-extended
#define applyu_f8up(u,f) (((unsigned int)(u)*((f)+1)+UINTF8_HALF)>>8)
#define applys_f8up(s,f) (((int)(s)*((f)+1)+UINTF8_HALF)>>8) //sign-extended
#define applyu_f8ex(u,f) ((f)==0? 0: (f)==UINTF8_MAX? (u): applyu_f8mid(u,f))
#define applys_f8ex(s,f) ((f)==0? 0: (f)==UINTF8_MAX? (s): applys_f8mid(u,f))
#define applyu_f80up(u,f) ((f)==0? 0: applyu_f8up(u,f)) //0, otherwise up
#define applys_f80up(s,f) ((f)==0? 0: applys_f8up(s,f)) //0, otherwise up
#define applyu_f8down1(u,f) ((f)==UINTF8_MAX? (u): applyu_f8down(u,f)) //1, otherwise down
#define applys_f8down1(s,f) ((f)==UINTF8_MAX? (s): applys_f8down(s,f)) //1, otherwise down
#endif

#ifndef applyu_f15
#define applyu_f15(u,f) (((unsigned int)(u)*(f)+UINTF15_HALF)>>15)
#define applys_f15(s,f) (((int)(s)*(f)+UINTF15_HALF)>>15) //sign-extend
#define applyu_f16mid(u,f) (((unsigned int)(u)*(((f)<<1)|1)+(UINTF16_PIECES+UINTF16_HALF))>>17)
#define applys_f16mid(s,f) (((int)(s)*(((f)<<1)|1)+(UINTF16_PIECES+UINTF16_HALF))>>17) //sign-extended
#define applyu_f16down(u,f) (((unsigned int)(u)*(f)+UINTF16_HALF)>>16)
#define applys_f16down(s,f) (((int)(s)*(f)+UINTF16_HALF)>>16) //sign-extended
#define applyu_f16up(u,f) (((unsigned int)(u)*((f)+1)+UINTF16_HALF)>>16)
#define applys_f16up(s,f) (((int)(s)*((f)+1)+UINTF16_HALF)>>16) //sign-extended
#define applyu_f16ex(u,f) ((f)==0? 0: (f)==UINTF16_MAX? (u): applyu_f16mid(u,f))
#define applys_f16ex(s,f) ((f)==0? 0: (f)==UINTF16_MAX? (s): applys_f16mid(u,f))
#define applyu_f160up(u,f) ((f)==0? 0: applyu_f16up(u,f)) //0, otherwise up
#define applys_f160up(s,f) ((f)==0? 0: applys_f16up(s,f)) //0, otherwise up
#define applyu_f16down1(u,f) ((f)==UINTF16_MAX? (u): applyu_f16down(u,f)) //1, otherwise down
#define applys_f16down1(s,f) ((f)==UINTF16_MAX? (s): applys_f16down(s,f)) //1, otherwise down
#endif

#endif //ATCRT_TYPES_ONLY

#define AT_FIXEDPOINT_TYPES
#if !defined(ATCRT_TYPES_ONLY)
	#define AT_FIXEDPOINT_ALL
#endif

#endif
