#pragma once
#include "COMPILER_resolve.h"
#if COMPILER_ID!=0
#include mergestring(ATiflike_,COMPILER.h)
#endif

/*`if' branches with hint to the compiler as to their likelihood. If a compiler supported it
the definitions would look like

#define _likely __likely__	//Should only be applied to atomic conditions, else the compiler should issue an error.
#define _unlikely __unlikely__
#define iflike(a) if(_likely(a))
#define ifunlike(a) if(_unlikely(a))

But the ones here are intended for system_<COMPILER>.h files that do not provide any
because they don't suport it, so just:*/

#ifndef _likely
	#define _likely(a) (a)
	#define _unlikely(a) (a)
	#ifndef iflike
	#define iflike if
	#define ifunlike if
	#endif
#else
	#ifndef iflike
	#define iflike(a) if(_likely(a))
	#define ifunlike(a) if(_unlikely(a))
	#endif
#endif
