//Matches the definitions of stdlib.h (where they are _MAX_PATH and _MAX_DIR)
//minwidef.h defines MAX_PATH (but not _MAX_PATH neither MAX_DIR)
#define MAX_PATH   260 // max. length of full pathname
#define MAX_DIR    256 // max. length of path component

#define path_empty_is_valid 1
#define STR8_thisdir ".\\"
#define STR8_backdir "..\\"
#define STR8_pathsep "\\"
#define CHR8_pathsep '\\'
#define STR8_invalidpathchars "*?\"<>|"
#define STR16_thisdir u".\\"
#define STR16_backdir u"..\\"
#define STR16_pathsep u"\\"
#define CHR16_pathsep '\\'
#define STR16_invalidpathchars u"*?\"<>|"
#define STRLEN_pathsep 1
#define STRLEN_paththis 2
#define STRLEN_pathback 3
#define ispath_sep(s) (*(s)=='\\' || *(s)=='/')

#define Path_isabs(s) (*(s)>='A' && *(s)<='Z' && *(s+1)==':' && ispath_sep(s+2))
#define Path_isthis(s) (*(s)=='.' && ispath_sep(s+1) && *(s+2)=='\0')
#define Path_isback(s) (*(s)=='.' && *(s+1)=='.' && ispath_sep(s+2) && *(s+3)=='\0')
#define Path_sep(s) *(s)='\\', *(s+1)='\0'
#define Path_this(s) *(s)='.', *(s+1)='\\', *(s+2)='\0'
#define Path_back(s) *(s)='.', *(s+1)='.', *(s+2)='\\', *(s+3)='\0'

#define path_isthis(s) (*(s)=='.' && ispath_sep(s+1))
#define path_isback(s) (*(s)=='.' && *(s+1)=='.' && ispath_sep(s+2))
/*Explicit relative path (does not include the empty string)*/
#define path_isexrel(s) (*(s)=='.' && (ispath_sep(s+1) || (*(s+1)=='.' && ispath_sep(s+2)) ) )
#define path_sep(s) *(s)++='\\'
#define path_this(s) *(s)++='.', *(s)++='\\'
#define path_back(s) *(s)++='.', *(s)++='.', *(s)++='\\'

#define path_skipabs(s) (s)+=3
#define path_skipsep(s) (s)++
#define path_skipthis(s) (s)+=2
#define path_skipback(s) (s)+=3
#define path_unsep(s,bottom) iflike((s)!=(bottom)) (s)--
#define path_unsep_unsafe(s) (s)--

/*Adds a path separator to the end of s if not already present*/
#define path_append_sep_ifneeded8_ptr(path,s) {s=path; while(*s) s++; if(s==path || !ispath_sep(s-1)){Path_sep(s); s+=STRLEN_pathsep;}}
#define path_append_sep_ifneeded16_ptr(path,s) {s=path; while(*s) s++; if(s==path || !ispath_sep(s-1)){Path_sep(s); s+=STRLEN_pathsep;}}
#define path_append_sep_ifneeded8(path) {char8_t *_s=path; while(*_s) _s++; if(_s==path || !ispath_sep(_s-1)) Path_sep(_s);}
#define path_append_sep_ifneeded16(path) {char16_t *_s=path; while(*_s) _s++; if(_s==path || !ispath_sep(_s-1)) Path_sep(_s);}
/*s ha de quedar apuntando al princpio del nombre del fichero*/
#define path_get_filename8(path,s) {s=path; while(*s) s++; while(!ispath_sep(s) && s--!=path); s++;}
#define path_get_filename16 path_get_filename8
#define path_remove_file_ptr8(path,s) {path_get_filename8(path,s); *s='\0';}
#define path_remove_file_ptr16(path,s) {path_get_filename16(path,s); *s='\0';}
#define path_remove_file8(path) {char8_t *s; path_remove_file_ptr8(path,s);}
#define path_remove_file16(path) {char16_t *s; path_remove_file_ptr16(path,s);}
/*s ha de quedar apuntando al punto de la extensión o al final de la cadena si no hay extensión*/
#define path_get_extension8(path,s) {s=path; while(*s) s++;\
												while(*s!='.' && s!=path && !ispath_sep(s)) s--;\
												ifunlike(*s!='.'){while(*s!='\0') s++;}}
#define path_get_extension16 path_get_extension8
#define path_remove_extension_ptr8(path,s) {path_get_extension8(path,s); *s='\0';}
#define path_remove_extension_ptr16(path,s) {path_get_extension16(path,s); *s='\0';}
#define path_remove_extension8(path) {char8_t *s; path_remove_extension_ptr8(path,s);}
#define path_remove_extension16(path) {char16_t *s; path_remove_extension_ptr16(path,s);}
