/* SHRT_PATH and SHRT_DIR.
Some functions of this library use buffers with size SHRT_PATH and SHRT_DIR.
If the system defines MAX_PATH and MAX_DIR the former values should not exceed
the latter. In case the system imposes no limitations SHRT_PATH is set to 300 and
SHRT_DIR to a (SHRT_PATH-20). */

//Warn the user if SHRT_PATH changes its value upon reading this file
//To this end we use a provisional name to store the new value

#ifdef MAX_PATH
	#define SHRT_PATH_PROV MAX_PATH
#elif defined(_MAX_PATH)
	#define SHRT_PATH_PROV _MAX_PATH
#endif
#ifndef SHRT_PATH_PROV
	#define SHRT_PATH_PROV 300
#endif

#define SHRT_path_change_report1(s,O,N) Diagnostic_Message(s #O " " #N)
#define SHRT_path_change_report(s,O,N) SHRT_path_change_report1(s,O,N)
#define shrt_path_change_report(s) SHRT_path_change_report(s,SHRT_PATH,SHRT_PATH_PROV)

#if defined(SHRT_PATH)
	#if (SHRT_PATH_PROV!=SHRT_PATH)
		shrt_path_change_report("The value of the SHRT_PATH macro has changed upon inclusion of srt_path.h. The old and new values are: ")
	#endif
	#undef SHRT_PATH
#endif
#undef SHRT_PATH_PROV

//Actual definition
#ifdef MAX_PATH
	#define SHRT_PATH MAX_PATH
#elif defined(_MAX_PATH)
	#define SHRT_PATH _MAX_PATH
#endif
#ifndef SHRT_PATH
	#define SHRT_PATH 300
#endif

#undef SHRT_DIR
#ifdef MAX_DIR
	#define SHRT_DIR MAX_DIR
#elif defined(_MAX_DIR)
	#define SHRT_DIR _MAX_DIR
#endif
#ifndef SHRT_DIR
	#define SHRT_DIR (SHRT_PATH-20)
#elif SHRT_DIR>SHRT_PATH-8
	#undef SHRT_DIR
	#define SHRT_DIR (SHRT_PATH-8)
#endif
