﻿#pragma once
#ifndef sinline
#define sinline static inline
#endif

//Los valores de λ han de pasarse siempre respecto al meridiano central

#ifdef __cplusplus
extern "C"{
#endif

sinline double radN(double a,double e, double sinφ){
	double x=1-e*sinφ*sinφ;
	return a/sqrt(x);
}
sinline double ρ_by_N(double e, double sinφ){
	double x=sinφ*sinφ;
	return (1-e)/(1-e*x);
}
sinline double ρ(double a,double e, double sinφ){
	double x;
	x=sinφ;
	x=1-e*x*x;
	x*=sqrt(x);
	return (1-e)*a/x;
}
sinline double Nρ(double a,double e, double sinφ){
	double x;
	x=(1-e*sinφ*sinφ);
	x*=(1-e)*x*x;
	return x*a*a;
}

double lam(double a, double e, double φ);
double φ___lam(double a, double e, double lam);

/* Las funciones devuelven / reciben el radio de la estereográfica proyectada sobre el plano
ecuatorial. Es por tanto la mitad del radio de la proyección cartográfica.
    Emplean una proyección estereográfica SUR.

Φ: Latitud en la esfera de manera que (λ,Φ) en la esfera <-> (λ,φ) en el elipsoide es conforme.
ΦM: Φ de la proyección Mercator; e.d., (λ,ΦM) en el plano <-> (λ,φ) en el elipsoide es conforme.
rST: Radio (distancia al centro) en la proyección estereográfica c. en el polo Sur = e^ΦM
rST2: El cuadrado del radio en la proyección estereográfica c. en el polo Sur = e^(2*ΦM)
*/

//Funciones directas
double rST2_sinφ(double e, double sinφ);
double ΦM___sinφ(double e, double sinφ);
double sinΦ___sinφ(double e, double sinφ);
//.x será sinΦ; .y será cosΦ
Puntoxy_double sinΦcosΦ___φ(double e, double φ);
sinline double rST2_φ(double e, double φ){
	return rST2_sinφ(e,sin(φ));
}
sinline double ΦM___φ(double e, double φ){
	return ΦM___sinφ(e, sin(φ));
}
sinline double sinΦ___φ(double e, double φ){
	return sinΦ___sinφ(e,sin(φ));
}
sinline double Φ___sinφ(double e, double sinφ){
	return asin(sinΦ___sinφ(e,sinφ));
}
sinline double Φ___φ(double e, double φ){
	return asin(sinΦ___sinφ(e,sin(φ)));
}
//Funciones inversas
double sinφ___rST2_sinφapprox(double e, double rST2,double sinφapprox);
double sinφ___sinΦ(double e, double sinΦ);
sinline double sinφ___rST2(double e, double rST2){
	double sinφ=(rST2-1)/(rST2+1);
	return sinφ___rST2_sinφapprox(e,rST2,sinφ);
}
sinline double φ___rST2_sinφapprox(double e, double rST2,double sinφapprox){
	return asin(sinφ___rST2_sinφapprox(e,rST2,sinφapprox));
}
sinline double φ___rST2(double e, double rST2){
	double sinφ=(rST2-1)/(rST2+1);
	return φ___rST2_sinφapprox(e,rST2,sinφ);
}
sinline double φ___rST(double e, double rST){
	return φ___rST2(e,rST*rST);
}
sinline double sinφ___ΦM(double e, double ΦM){
	double c=exp(2*ΦM);
	return sinφ___rST2(e,c);
}
sinline double φ___ΦM(double e, double ΦM){
	double c=exp(2*ΦM);
	return φ___rST2(e,c);
}
sinline double sinφ___Φ(double e, double Φ){
	return sinφ___sinΦ(e,sin(Φ));
}
sinline double φ___sinΦ(double e, double sinΦ){
	return asin(sinφ___sinΦ(e,sinΦ));
}
sinline double φ___Φ(double e, double Φ){
	return asin(sinφ___sinΦ(e,sin(Φ)));
}

//Funciones para coordenadas sin xO ni yS ni k0
double k_UTM_GRS80(double X, double Y, double a);
double ajuste_kUTM(double a, double e, double x, double y);
//Función para coordenadas sin xO ni yS, pero con k0.
sinline double kUTM___xy(double a,double e, double x,double y,double k0){
	double k;
	x/=k0;		y/=k0;
	k=k_UTM_GRS80(x,y,a);
	if(e<0.0066 || e>0.00685) k*=ajuste_kUTM(a,e,x,y);
	return k*k0;
}

double kLambert___φ(const Sistema *sis, double φ);
double kMercator___φ(const Sistema *sis, double φ);
double kEstereoPolar___φ(const Sistema *sis, double φ);

//Funciones que no aplican ni k0 ni xO ni yS
Puntoxy_double UTM_λφ___xy(double a,double e,Puntoxy_double p);
Puntoxy_double UTM_xy___λφ(double a,double e,Puntoxy_double p);
double UTM_conv___λφ(double e,double λ,double φ);

double conv_meridianos(const Sistema *sis,double λ,double φ);
#ifdef __cplusplus
}
#endif
