//Poor man's sqrt.
static uint sqrtpm(uint nn){
	static const uint sqrtsmall[64]={
		0,
		1,1,2,2,   2,2,3,3,   //1-8
		3,3,3,3,  4,4,4,4,  //9-16
		4,4,4,4, 5,5,5,5,   //17-24
		5,5,5,5,  5,5,6,6,  //25-32
		6,6,6,6, 6,6,6,6, //33-40
		6,6,7,7,  7,7,7,7,  //41-48
		7,7,7,7,  7,7,7,7,  //49-56
		8,8,8,8, 8,8,8,	 //57-63
	};
	if(nn==0) return 0;

	uint n=1;
	if(nn&0xFFFC0000) nn>>=14, n<<=7;
	if(nn&0x3F000) nn>>=8, n<<=4;
	if(nn&0xF00) nn>>=4, n<<=2;
	if(nn&0xC0) nn>>=2, n<<=1;
	n*=sqrtsmall[nn];

	return n;
}
